% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epanetmsx.rpt-s3.r
\name{read.msxrpt}
\alias{read.msxrpt}
\alias{epanetmsx.rpt}
\title{Read msx results}
\usage{
read.msxrpt(file)
}
\arguments{
\item{file}{the name of the file to read}
}
\value{
Returns an epanetmsx.rpt S3 object . 

\item{nodeResults}{data.frame}
\item{linkResults}{data.frame}
}
\description{
reads an Epanet-msx .rpt file into R
}
\details{
Specify the needed outputs from an Epanet-msx simulation in the
 [REPORT] section of the .msx file to create reports for reading  
 with this function. 

The function returns an S3 object (list) with a data.frame for node results and
data.frame for link results.  These data.frames contain results from all
the time periods to facilitate time series plots.
}
\examples{
# path to example file included with this package
msr <- file.path( find.package("epanetReader"), "extdata","example.rpt") 

#read the results into R
x <- read.msxrpt(msr)
names(x)
summary(x)
plot(x)
}
\references{
Shang, F., Uber, J.G., Rossman, L.A. (2011)
            EPANET Multi-species Extension User's Manual.
            US Environmental Protection Agency, Cincinnati.
}
