#'Funcion para etiquetar las bases de la Encuesta Permanente de Hogares.
#'
#'@param df type de microdatos de la EPH
#'@param type string. aclaracion de si se quiere etiquetar una type 'individual' u 'hogar'
#'@details
#'disclaimer: El script no es un producto oficial de INDEC.
#'@examples
#'df <- organize_labels(toybase_individual_2016_04, type='individual')
#'@export


organize_labels <- function(df, type = "individual"){

  assertthat::assert_that(is.data.frame(df))
  assertthat::assert_that(type %in% c("individual", "hogar"))

  if(type == "hogar"){
    df = expss::apply_labels(df,
                             CODUSU = 'Codigo para distinguir VIVIENDAS, permite aparearlas con Hogares y Personas. Ademas permite hacer el seguimiento a traves de los trimestres',
                             ANO4 = 'Anio de relevamiento',
                             TRIMESTRE = 'Ventana de Observacion',
                             TRIMESTRE = c("1er Trimestre" = 1,
                                           "2do Trimestre" = 2,
                                           "3er Trimestre" = 3,
                                           "4to Trimestre" = 4),
                             NRO_HOGAR = 'Codigo para distinguir HOGARES, permite aparearlos con Personas',
                             REALIZADA = 'Entrevista individual realizada',
                             REALIZADA = c("Si" = 1,
                                           "No." = 2),
                             REGION = 'Codigo de Region',
                             REGION = c("Gran Buenos Aires" = 1,
                                        "Noroeste" = 40,
                                        "Nordeste" = 41,
                                        "Cuyo" = 42,
                                        "Pampeana" = 43,
                                        "Patagonica." = 44),
                             MAS_500 = 'Aglomerados segun tamanio',
                             AGLOMERADO = 'Codigo de Aglomerado',
                             AGLOMERADO = c("Gran La Plata" = 2,
                                            "Bahia Blanca - Cerri" = 3,
                                            "Gran Rosario" = 4,
                                            "Gran Santa Fe" = 5,
                                            "Gran Parana" = 6,
                                            "Posadas" = 7,
                                            "Gran Resistencia" = 8,
                                            "Cdro. Rivadavia - R.Tilly" = 9,
                                            "Gran Mendoza" = 10,
                                            "Corrientes" = 12,
                                            "Gran Cordoba" = 13,
                                            "Concordia" = 14,
                                            "Formosa" = 15,
                                            "Neuquen - Plottier" = 17,
                                            "S. del Estero - La Banda" = 18,
                                            "Jujuy - Palpala" = 19,
                                            "Rio Gallegos" = 20,
                                            "Gran Catamarca" = 22,
                                            "Salta" = 23,
                                            "La Rioja" = 25,
                                            "San Luis - El Chorrillo" = 26,
                                            "Gran San Juan" = 27,
                                            "Gran Tucuman - T. Viejo" = 29,
                                            "Santa Rosa - Toay" = 30,
                                            "Ushuaia - Rio Grande" = 31,
                                            "Ciudad de Buenos Aires" = 32,
                                            "Partidos del GBA" = 33,
                                            "Mar del Plata - Batan" = 34,
                                            "Rio Cuarto" = 36,
                                            "San Nicolas - Villa Constitucion" = 38,
                                            "Rawson - Trelew" = 91,
                                            "Viedma - Carmen de Patagones." = 93),
                             PONDERA = 'Ponderacion',
                             IV1 = 'Tipo de vivienda',
                             IV1 = c("Casa" = 1,
                                     "Departamento" = 2,
                                     "Pieza de inquilinato" = 3,
                                     "Pieza en hotel/pension" = 4,
                                     "Local no construido para habitacion" = 5,
                                     "Otros. Especificar." = 6),
                             IV1_ESP = 'Otros (Especificar)',
                             IV2 = 'Cuantos ambientes/  habitaciones  tiene  la  vivienda en  total?  (sin  contar  banio/s,  cocina,  pasillo/s,lavadero, garage)',
                             IV3 = 'Los pisos interiores son principalmente de...',
                             IV3 = c("Mosaico/baldosa/madera/ceramica/alfombra" = 1,
                                     "Cemento/ladrillo fijo" = 2,
                                     "Ladrillo suelto/tierra" = 3,
                                     "Otros. Especificar." = 4),
                             IV3_ESP = 'Otros. Especificar',
                             IV4 = 'La cubierta exterior del techo es de....',
                             IV4 = c("Membrana/cubierta asfaltica" = 1,
                                     "Baldosa/losa sin cubierta" = 2,
                                     "Pizarra/teja" = 3,
                                     "Chapa de metal sin cubierta" = 4,
                                     "Chapa de fibrocemento/plastico" = 5,
                                     "Chapa de carton" = 6,
                                     "Cana/tabla/paja con barro/paja sola" = 7,
                                     "N/S. Depto en propiedad horizontal." = 9),
                             IV5 = 'El techo tiene cielorraso/revestimiento interior?',
                             IV5 = c("Si" = 1,
                                     "No." = 2),
                             IV6 = 'Tiene agua...',
                             IV6 = c("Por caneria dentro de la vivienda" = 1,
                                     "Fuera de la vivienda pero dentro del terreno" = 2,
                                     "Fuera del terreno." = 3),
                             IV7 = 'El agua es de...',
                             IV7 = c("Red publica (agua corriente)" = 1,
                                     "Perforacion con bomba a motor" = 2,
                                     "Perforacion con bomba manual" = 3,
                                     "Otras fuentes." = 4),
                             IV7_ESP = 'Otras fuentes. Especificar',
                             IV8 = 'Tiene banio/letrina?',
                             IV8 = c("Si" = 1,
                                     "No." = 2),
                             IV9 = 'El banio o letrina esta...',
                             IV9 = c("Si" = 1,
                                     "No." = 2),
                             IV10 =	'El banio tiene...',
                             IV10 = c("Dentro de la vivienda" = 1,
                                      "Fuera de la vivienda pero dentro del terreno" = 2,
                                      "Fuera del terreno." = 3),
                             IV11 =	'El desague del banio es...',
                             IV11 = c("Inodoro  con  boton/  mochila/ cadena y  arrastre	de agua" = 1,
                                      "Inodoro sin boton/cadena y con arrastre de agua (a balde)" = 2,
                                      "Letrina (sin arrastre de agua)." = 3),
                             IV12_1 =	'La vivienda esta ubicada cerca de basural/es(3 cuadras O menos)',
                             IV12_1 = c("Si" = 1,
                                        "No." = 2),
                             IV12_2 =	'La vivienda esta ubicada en zona inundable (en los ultimos 12 meses)',
                             IV12_2 = c("Si" = 1,
                                        "No." = 2),
                             IV12_3 =	'La vivienda esta ubicada en villa de emergencia (por observacion)',
                             IV12_3 = c("Si" = 1,
                                        "No." = 2),
                             II1 =		'Cuantos  ambientes/  habitaciones tiene este  hogar para su uso exclusivo?',
                             II2 =	'De esos, cuantos usan habitualmente para dormir?',
                             II3 =	'Utiliza alguno exclusivamente como lugar de Trabajo(paraconsultorio,estudio,taller, negocio, etc.).',
                             II3 = c("Si" = 1,
                                     "No." = 2),
                             II3_1 =	'Si utiliza alguno exclusivamente como lugar de	Trabajo Cuantos?.',
                             II4_1 =	'Tiene ademas...	Cuarto de cocina.',
                             II4_1 = c("Si" = 1,
                                       "No." = 2),
                             II4_2 =	'Tiene ademas... Lavadero.',
                             II4_2 = c("Si" = 1,
                                       "No." = 2),
                             II4_3 = 'Tiene ademas... Garage.',
                             II4_3 = c("Si" = 1,
                                       "No." = 2),
                             II5 = 'De esos ...(los si de preg.4) usan alguno para dormir.',
                             II5 = c("Si" = 1,
                                     "No." = 2),
                             II5_1 = 'Si Utiliza alguno para dormir Cuantos?.',
                             II6 = 'De esos ...(los si de preg.4) utiliza alguno de	estos exclusivamente como lugar	de trabajo (consultorio, estudio, taller, negocio, etc.).',
                             II6 = c("Si" = 1,
                                     "No." = 2),
                             II6_1 = 'Si utiliza alguno exclusivamente como lugar de	trabajo Cuantos?',
                             II7 = 'Regimen de tenencia',
                             II7 = c("Propietario de la vivienda y el terreno" = 1,
                                     "Propietario de la vivienda solamente" = 2,
                                     "Inquilino/arrendatario de la vivienda" = 3,
                                     "Ocupante por pago de impuestos/expensas" = 4,
                                     "Ocupante en relacion de dependencia" = 5,
                                     "Ocupante gratuito (con permiso)" = 6,
                                     "Ocupante de hecho (sin permiso)" = 7,
                                     "Esta en sucesion?" = 8,
                                     "Otra situacion (Especificar).." = 9),
                             II7_ESP = 'Otra situacion (Especificar).',
                             II8 = 'Combustible utilizado para cocinar',
                             II8 = c("Gas de red" = 1,
                                     "Gas de tubo/garrafa" = 2,
                                     "Kerosene/ lena/ carbon" = 3,
                                     "Otro (Especificar)." = 4),
                             II8_ESP = 'Otro. Especificar.',
                             II9 = 'Banio (tenencia y uso).',
                             II9 = c ("Uso exclusivo del hogar" = 1,
                                      " Compartido  con  otro/s  hogar/es  de  la  misma	vivienda" = 2,
                                      "Compartido con otra/s vivienda/s" = 3,
                                      "No tiene banio." = 4),
                             V1 = 'En los ultimos tres meses	 las personas de este hogar han vivido... de lo que ganan en el trabajo?.',
                             V1 = c("Si" = 1,
                                    "No." = 2),
                             V2 = 'En los ultimos tres meses	 las personas de este hogar han vivido... de alguna jubilacion o pension?.',
                             V2 = c("Si" = 1,
                                    "No." = 2),
                             V21 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... Aguinaldo de	alguna	jubilacion	o  pension cobrada el mes anterior?',
                             V21 = c("Si" = 1,
                                     "No." = 2),
                             V22 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... Retroactivo de	alguna jubilacion o pension que cobro el mes anterior?',
                             V22 = c("Si" = 1,
                                     "No." = 2),
                             V3 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... indemnizacion por despido?',
                             V3 = c("Si" = 1,
                                    "No." = 2),
                             V4 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... seguro de desempleo?',
                             V14= c("Si" = 1,
                                    "No." = 2),
                             V5 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... desubsidio	oayuda	social(en	dinero) del gobierno, iglesias, etc.?',
                             V5 = c("Si" = 1,
                                    "No." = 2),
                             V6 =	'En los ultimos tres meses	 las personas de este hogar han vivido con...  mercaderias,  ropa,  alimentos			del gobierno	iglesias, escuelas,	etc.?',
                             V6 = c("Si" = 1,
                                    "No." = 2),
                             V7 =	'En los ultimos tres meses	 las personas de este hogar han vivido con... mercaderias, ropa, alimentos de familiares,	vecinos u otras personas que no viven en  este	hogar?		',
                             V7 = c("Si" = 1,
                                    "No." = 2),
                             V8 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... algun alquiler (por una vivienda, terreno,	oficina, etc.)de su propiedad?',
                             V8 = c("Si" = 1,
                                    "No." = 2),
                             V9 = 'En los ultimos tres meses	 las personas de este hogar han vivido de... ganancias de algun negocio enel que  no	trabajan?',
                             V9 = c("Si" = 1,
                                    "No." = 2),
                             V10 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... intereses o rentas por  plazos fijos/	inversiones?',
                             V10 = c("Si" = 1,
                                     "No." = 2),
                             V11 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... una beca de estudio?',
                             V11 = c("Si" = 1,
                                     "No." = 2),
                             V12 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... cuotas de alimentos o  ayuda  en  dinero  de	personas que no viven en el hogar?',
                             V12 = c("Si" = 1,
                                     "No." = 2),
                             V13 =	'En los ultimos tres meses	 las personas de este hogar han vivido con... gastar lo que tenian ahorrado?',
                             V13 = c("Si" = 1,
                                     "No." = 2),
                             V14 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... pedir prestamos a familiares/amigos',
                             V14 = c("Si" = 1,
                                     "No." = 2),
                             V15 =	'En los ultimos tres meses	 las personas de este hogar han vivido de... pedir prestamos a bancos, financieras, etc.?',
                             V15 = c("Si" = 1,
                                     "No." = 2),
                             V16 = 'En los ultimos tres meses	 las personas de este hogar han vivido de... Compran en  cuotas  o  al  fiado  con  tarjeta  de	credito o libreta?',
                             V16 = c("Si" = 1,
                                     "No." = 2),
                             V17 =	'Han tenido que vender alguna de sus pertenencias?',
                             V17 = c("Si" = 1,
                                     "No." = 2),
                             V18 =		'Tuvieron otros  ingresos  en  efectivo  (limosnas,	juegos de azar, etc.)',
                             V18 = c("Si" = 1,
                                     "No." = 2),
                             V19_A =	'menores de  10  anios  ayudan  con  algun  dinero		trabajando?',
                             V19_A = c("Si" = 1,
                                       "No." = 2),
                             V19_B =	'Menores de  10  anios  ayudan  con  algun  dinero	pidiendo?',
                             V19_B = c("Si" = 1,
                                       "No." = 2),
                             IX_TOT =		'Cantidad de miembros del Hogar',
                             IX_MEN10 =		'Cantidad de miembros del Hogar menores de 10 anios',
                             IX_MAYEQ10 =		'Cantidad de miembros del Hogar de 10 y mas anios',
                             ITF =		'MONTO DE INGRESO TOTAL FAMILIAR',
                             DECIFR =		'Nro de decil del ingreso total del hogar del TOTAL	EPH',
                             IDECIFR =		'Nro de decil del ingreso total del hogar del TOTAL	EPH',
                             RDECIFR = 	'Nro de	decil de  ingreso  total  del  hogar  de  la	REGION.',
                             GDECIFR = 	'Nro de	decil de  ingreso  total  del  hogar	del	Conjunto	de AGLOMERADOS DE 500 MIL	Y MAS	HABITANTES.',
                             PDECIFR = 	'Nro de	decil de  ingreso  total  del  hogar	del	Conjunto  de  AGLOMERADOS  DE  MENOS  DE  500  MIL	HABITANTES',
                             ADECIFR = 	'Nro  de  decil  de  ingreso  total  del  hogar  del	AGLOMERADO',
                             IPCF = 	'Monto de ingreso per capita familiar(ver AnexoI)',
                             DECCFR = 	'Nro de	decil del  ingreso  per  capita  familiar  del	TOTAL EPH',
                             IDECCFR = 	'Nro  de  decil  del  ingreso  per  capita  familiar  del	INTERIOR',
                             RDECCFR = 	'Nro de	decil de  ingreso  per  capita  familiar  de  la	REGION',
                             GDECCFR = 	'Nro  de  decil  de  ingreso  per  capita  familiar  del	Conjunto	de AGLOMERADOS DE 500 MIL	Y MAS	HABITANTES',
                             PDECCFR = 	'Nro  de  decil  de  ingreso  per  capita  familiar  del	Conjunto  de  AGLOMERADOS  DE  MENOS  DE  500  MIL	HABITANTES',
                             ADECCFR = 	'Nro  de  decil  de  ingreso  per  capita  familiar  del	AGLOMERADO',
                             PONDIH = 'Ponderador  del  ingreso  total  familiar  y		del	ingreso per capita familiar',
                             VII1_1 = 	'Realizacion de las tareas de la casa		- Numero de componente del hogar',
                             VII1_1 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar." = 97),
                             VII1_2 =		'Realizacion de las tareas de la casa - Numero de componente del hogar',
                             VII1_2 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar." = 97),
                             VII2_1 =		'Otras personas que ayudan en las tareas de la casa		- Numero de componente del hogar',
                             VII2_1 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar" = 97,
                                        "Ninguna." = 98),
                             VII2_2 =		'Otras personas que ayudan en las tareas de la casa	- Numero de componente del hogar',
                             VII2_2 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar" = 97,
                                        "Ninguna." = 98),
                             VII2_3 =		'Otras personas que ayudan en las tareas de la casa	- Numero de componente del hogar',
                             VII2_3 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar" = 97,
                                        "Ninguna." = 98),
                             VII2_4 =		'Otras personas que ayudan en las tareas de la casa - Numero de componente del hogar',
                             VII2_4 = c("Servicio domestico" = 96,
                                        "Otra persona que no vive en el hogar" = 97,
                                        "Ninguna." = 98))
  }

  else if(type == "individual"){
    df = expss::apply_labels(df,
                             CODUSU = 'Codigo para distinguir VIVIENDAS, permite aparearlas con Hogares y Personas. Ademas permite hacer el seguimiento a traves de los trimestres',
                             NRO_HOGAR = ' Codigo para distinguir HOGARES, permite aparearlos con Personas',
                             COMPONENTE = 'Numero de componente: N\u00b0 de orden que se asigna a las personas que conforman cada hogar de la vivienda',
                             COMPONENTE = c("Servicio Domestico en hogares" = 51,
                                            "Pensionistas en hogares" = 71),
                             H15 = 'Entrevista individual realizada',
                             H15 = c("Si" = 1,
                                     "No" = 2),
                             ANO4 = 'Anio de relevamiento',
                             TRIMESTRE = 'Ventana de Observacion',
                             TRIMESTRE = c("1er Trimestre" = 1,
                                           "2do Trimestre" = 2,
                                           "3er Trimestre" = 3,
                                           "4to Trimestre" = 4),
                             REGION = 'Codigo de Region',
                             REGION = c("Gran Buenos Aires" = 01,
                                        "Noroeste" = 40,
                                        "Nordeste" = 41,
                                        "Cuyo" = 42,
                                        "Pampeana" = 43,
                                        "Patagonica"),
                             MAS_500 = 'Aglomerados segun tamanio',
                             AGLOMERADO = 'Codigo de Aglomerado',
                             AGLOMERADO = c("Gran La Plata" = 2,
                                            "Bahia Blanca - Cerri" = 3,
                                            "Gran Rosario" = 4,
                                            "Gran Santa Fe" = 5,
                                            "Gran Parana" = 6,
                                            "Posadas" = 7,
                                            "Gran Resistencia" = 8,
                                            "Cdro. Rivadavia - R.Tilly" = 9,
                                            "Gran Mendoza" = 10,
                                            "Corrientes" = 12,
                                            "Gran Cordoba" = 13,
                                            "Concordia" = 14,
                                            "Formosa" = 15,
                                            "Neuquen - Plottier" = 17,
                                            "S. del Estero - La Banda" = 18,
                                            "Jujuy - Palpala" = 19,
                                            "Rio Gallegos" = 20,
                                            "Gran Catamarca" = 22,
                                            "Salta" = 23,
                                            "La Rioja" = 25,
                                            "San Luis - El Chorrillo" = 26,
                                            "Gran San Juan" = 27,
                                            "Gran Tucuman - T. Viejo" = 29,
                                            "Santa Rosa - Toay" = 30,
                                            "Ushuaia - Rio Grande" = 31,
                                            "Ciudad de Buenos Aires" = 32,
                                            "Partidos del GBA" = 33,
                                            "Mar del Plata - Batan" = 34,
                                            "Rio Cuarto" = 36,
                                            "San Nicolas - Villa Constitucion" = 38,
                                            "Rawson - Trelew" = 91,
                                            "Viedma - Carmen de Patagones." = 93),
                             PONDERA = 'Ponderacion',
                             CH03 = 'Relacion de parentesco',
                             CH03 = c("Jefe/a" = 1,
                                      "Conyuge / Pareja" = 2,
                                      "Hijo/a Hijastro/a" = 3,
                                      "Yerno/Nuera" = 4,
                                      "Nietro/a" = 5,
                                      "Madre/Padre" = 6,
                                      "Suegro/a" = 7,
                                      "Hermano/a" = 8,
                                      "Otros Familiares" = 9,
                                      "No familiares" = 10),
                             CH04 = 'Sexo',
                             CH04 = c("Varon" = 1,
                                      "Mujer" = 2),
                             CH05 = 'Fecha de nacimiento (dia, mes y anio)',
                             CH06 = 'Edad en anios cumplidos',
                             CH07 = 'Actuamente esta...',
                             CH07 = c("unido?" = 1,
                                      "casado?" = 2,
                                      "separado/a o divorsiado/a?" = 3,
                                      "viudo/a?" = 4,
                                      "soltero/a?" = 5,
                                      "Ns/Nr." = 9),
                             CH08 = 'Tipo de cobertura medica',
                             CH08 = c("Obra social (incluye PAMI)" = 1,
                                      "Mutual / Prepaga / Servicio de emergencia" = 2,
                                      "Planes y seguros Publicos" = 3,
                                      "No paga ni le descuentan" = 4,
                                      "Ns./Nr." = 9,
                                      "Obra social y Mutual / Prepaga / Servicio de Emergencia" = 12,
                                      "Obra social y Planes y Seguros Publicos" = 13,
                                      "Mutual / Prepaga / Servicio de Emergencia / Planes y Seguros Publicos" = 23,
                                      "Obra social, mutual / prepaga / servicio de emergencia y planes y seguros pubilcos" = 123),
                             CH09 = 'Sabe leer y escribir?',
                             CH09 = c("Si" = 1,
                                      "No" = 2,
                                      "Menor de 2 anios." = 3),
                             CH10 = 'Asiste o asistio a algun establecimiento educativo? (colegio, escuela, universidad)',
                             CH10 = c("Si, asiste" = 1,
                                      "No asiste, pero asistio" = 2,
                                      "Nunca asistio" = 3,
                                      "Ns/Nr." = 9),
                             CH11 = 'Ese establecimiento es...',
                             CH11 = c("Publico" = 1,
                                      "Privado" = 2,
                                      "Ns./Nr.." = 9),
                             CH12 = 'Cual es el nivel mas alto que cursa o curso?',
                             CH12 = c("Jardin / Preescolar" = 1,
                                      "Primario" = 2,
                                      "EGB" = 3,
                                      "Secundario" = 4,
                                      "Polimodal" = 5,
                                      "Terciario" = 6,
                                      "Universitario" = 7,
                                      "Posgrado Univ." = 8,
                                      "Educacion especial (discapacitado)" = 9,
                                      "Ns/Nr." = 99),
                             CH13 = 'Finalizo ese nivel?',
                             CH13 = c("Si" = 1,
                                      "No" = 2,
                                      "Ns/Nr." = 9),
                             CH14 = 'Cual fue el ultimo anio que aprobo?',
                             CH14 = c("Ninguno" = 0,
                                      "Primero" = 1,
                                      "Segundo" = 2,
                                      "Tercero" = 3,
                                      "Cuarto" = 4,
                                      "Quinto" = 5,
                                      "Sexto" = 6,
                                      "Siptimo" = 7,
                                      "Octavo" = 8,
                                      "Noveno" = 9,
                                      "Educacion especial" = 98,
                                      "Ns/Nr." = 99),
                             CH15 = 'Donde nacio?',
                             CH15 = c("En esta localidad" = 1,
                                      "En otra localidad de esta provincia" = 2,
                                      "En otra provincia (especificar)" = 3,
                                      "En un pais limitrofe (especificar Brasil, Bolivia, Chile, Paraguay, Uruguay)" = 4,
                                      "En otro pais (especificar)" = 5,
                                      "Ns./Nr.." = 9),
                             CH15_COD = 'Codigo de provincia / pais / territorio',
                             CH15_COD = c("BUENOS AIRES" = 6,
                                          "CATAMARCA" = 10,
                                          "CORDOBA" = 14,
                                          "CORRIENTES" = 18,
                                          "CHACO" = 22,
                                          "CHUBUT" = 26,
                                          "ENTRE RIOS" = 30,
                                          "FORMOSA" = 34,
                                          "JUJUY" = 38,
                                          "LA PAMPA" = 42,
                                          "LA RIOJA" = 46,
                                          "MENDOZA" = 50,
                                          "MISIONES" = 54,
                                          "NEUQUEN" = 58,
                                          "RIO NEGRO" = 62,
                                          "SALTA" = 66,
                                          "SAN JUAN" = 70,
                                          "SAN LUIS" = 74,
                                          "SANTA CRUZ" = 78,
                                          "SANTA FE" = 82,
                                          "SGO. DEL ESTERO" = 86,
                                          "TUCUMAN" = 90,
                                          "TIERRA DEL FUEGO" = 94,
                                          "BURKINA FASO" = 101,
                                          "ARGELIA" = 102,
                                          "BOTSWANA" = 103,
                                          "BURUNDI" = 104,
                                          "CAMERUN" = 105,
                                          "REPUBLICA CENTROAFRICANA" = 107,
                                          "CONGO" = 108,
                                          "ZAIRE" = 109,
                                          "COSTA DE MARFIL" = 110,
                                          "CHAD" = 111,
                                          "BENIN" = 112,
                                          "EGIPTO" = 113,
                                          "GABON" = 115,
                                          "GAMBIA" = 116,
                                          "GHANA" = 117,
                                          "GUINEA" = 118,
                                          "GUINEA ECUATORIAL" = 119,
                                          "KENYA" = 120,
                                          "LESOTHO" = 121,
                                          "LIBERIA" = 122,
                                          "LIBIA" = 123,
                                          "MADAGASCAR" = 124,
                                          "MALAWI" = 125,
                                          "MALI" = 126,
                                          "MARRUECOS" = 127,
                                          "MAURICIO" = 128,
                                          "MAURITANIA" = 129,
                                          "NiGER" = 130,
                                          "NIGERIA" = 131,
                                          "ZIMBABWE" = 132,
                                          "RWANDA" = 133,
                                          "SENEGAL" = 134,
                                          "SIERRA LEONA" = 135,
                                          "SOMALIA" = 136,
                                          "SWAZILANDIA" = 137,
                                          "SUDAN" = 138,
                                          "TANZANIA" = 139,
                                          "TOGO" = 140,
                                          "TUNEZ" = 141,
                                          "UGANDA" = 142,
                                          "ZAMBIA" = 144,
                                          "TERRITORIOS VINCULADOS AL REINO UNIDO" = 145,
                                          "TERRITORIOS VINCULADOS A ESPANA" = 146,
                                          "TERRITORIOS VINCULADOS A FRANCIA" = 147,
                                          "ANGOLA" = 149,
                                          "CABO VERDE" = 150,
                                          "MOZAMBIQUE" = 151,
                                          "SEYCHELLES" = 152,
                                          "DJIBOUTI" = 153,
                                          "COMORAS" = 155,
                                          "GUINEA BISSAU" = 156,
                                          "SANTO TOME Y PRINCIPE" = 157,
                                          "NAMIBIA" = 158,
                                          "SUDAFRICA" = 159,
                                          "ERITREA" = 160,
                                          "ETIOPIA" = 161,
                                          "RESTO(AFRICA)" = 197,
                                          "INDETERMINADO(AFRICA)" = 198,
                                          "SIN DECLARAR-DESCONOCIDO-IGNORADO (AFRICA)" = 199,
                                          "ARGENTINA" = 200,
                                          "BARBADOS" = 201,
                                          "BOLIVIA" = 202,
                                          "BRASIL" = 203,
                                          "CANADA" = 204,
                                          "COLOMBIA" = 205,
                                          "COSTA RICA" = 206,
                                          "CUBA" = 207,
                                          "CHILE" = 208,
                                          "REPUBLICA DOMINICANA" = 209,
                                          "ECUADOR" = 210,
                                          "EL SALVADOR" = 211,
                                          "ESTADOS UNIDOS" = 212,
                                          "GUATEMALA" = 213,
                                          "GUYANA" = 214,
                                          "HAITI" = 215,
                                          "HONDURAS" = 216,
                                          "JAMAICA" = 217,
                                          "MEXICO" = 218,
                                          "NICARAGUA" = 219,
                                          "PANAMA" = 220,
                                          "PARAGUAY" = 221,
                                          "PERU" = 222,
                                          "PUERTO RICO (ESTADO ASOCIADO)" = 223,
                                          "TRINIDAD Y TOBAGO" = 224,
                                          "URUGUAY" = 225,
                                          "VENEZUELA" = 226,
                                          "TERRITORIOS VINCULADOS AL REINO UNIDO" = 227,
                                          "TERRITORIOS VINCULADOS A DINAMARCA" = 228,
                                          "TERRITORIOS VINCULADOS A FRANCIA" = 229,
                                          "TERRITORIOS VINCULADOS A LOS PAISES BAJOS" = 230,
                                          "TERRITORIOS VINCULADOS A ESTADOS UNIDOS" = 231,
                                          "SURINAME" = 232,
                                          "DOMINICA" = 233,
                                          "SANTA LUCIA" = 234,
                                          "SAN VICENTE Y LAS GRANADINAS" = 235,
                                          "BELICE" = 236,
                                          "ANTIGUA Y BARBUDA" = 237,
                                          "SAN CRISTOBAL Y NEVIS" = 238,
                                          "BAHAMAS" = 239,
                                          "GRENADA" = 240,
                                          "RESTO (AMERICA)" = 297,
                                          "INDETERMINADO (AMERICA)" = 298,
                                          "SIN DECLARAR-DESCONOCIDO-IGNORADO (AMERICA)" = 299,
                                          "AFGANISTAN" = 301,
                                          "ARABIA SAUDITA" = 302,
                                          "BAHREIN" = 303,
                                          "MYANMAR (EX BIRMANIA) UNION DE" = 304,
                                          "BUTAN" = 305,
                                          "CAMBODYA (EX KAMPUCHEA)" = 306,
                                          "SRI LANKA" = 307,
                                          "COREA DEMOCRATICA" = 308,
                                          "COREA REPUBLICANA" = 309,
                                          "CHINA" = 310,
                                          "FILIPINAS" = 312,
                                          "TAIWAN" = 313,
                                          "INDIA" = 315,
                                          "INDONESIA" = 316,
                                          "IRAQ" = 317,
                                          "IRAN" = 318,
                                          "ISRAEL" = 319,
                                          "JAPON" = 320,
                                          "JORDANIA" = 321,
                                          "QATAR" = 322,
                                          "KUWAIT" = 323,
                                          "LAO" = 324,
                                          "LIBANO" = 325,
                                          "MALASIA" = 326,
                                          "MALDIVAS" = 327,
                                          "OMAN" = 328,
                                          "MONGOLIA" = 329,
                                          "NEPAL" = 330,
                                          "EMIRATOS ARABES UNIDOS" = 331,
                                          "PAQUISTAN" = 332,
                                          "SINGAPUR" = 333,
                                          "SIRIA" = 334,
                                          "TAILANDIA" = 335,
                                          "VIETNAM" = 337,
                                          "TERRITORIOS VINCULADOS A PORTUGAL" = 344,
                                          "BANGLADESH" = 345,
                                          "BRUNEI" = 346,
                                          "REPUBLICA DE YEMEN" = 348,
                                          "ARMENIA" = 349,
                                          "AZERBAIDZHAN" = 350,
                                          "GEORGIA" = 351,
                                          "KAZAJSTAN" = 352,
                                          "KIRGUISTAN" = 353,
                                          "TAYIKISTAN" = 354,
                                          "TURKMENISTAN" = 355,
                                          "UZBEKISTAN" = 356,
                                          "TERRITORIOS AUTONOMOS PALESTINOS (GAZA Y JERICO)" = 357,
                                          "ESPECIALES (ASIA)" = 396,
                                          "RESTO (ASIA)" = 397,
                                          "INDETERMINADO(ASIA)" = 398,
                                          "SIN DECLARAR-DESCONOCIDO-IGNORADO (ASIA)" = 399,
                                          "ALBANIA" = 401,
                                          "ANDORRA" = 404,
                                          "AUSTRIA" = 405,
                                          "BELGICA" = 406,
                                          "BULGARIA" = 407,
                                          "DINAMARCA" = 409,
                                          "ESPANA" = 410,
                                          "FINLANDIA" = 411,
                                          "FRANCIA" = 412,
                                          "GRECIA" = 413,
                                          "HUNGRIA" = 414,
                                          "IRLANDA" = 415,
                                          "ISLANDIA" = 416,
                                          "ITALIA" = 417,
                                          "LIECHTENSTEIN" = 418,
                                          "LUXEMBURGO" = 419,
                                          "MALTA" = 420,
                                          "MONACO" = 421,
                                          "NORUEGA" = 422,
                                          "PAISES BAJOS" = 423,
                                          "POLONIA" = 424,
                                          "PORTUGAL" = 425,
                                          "REINO UNIDO" = 426,
                                          "RUMANIA" = 427,
                                          "SAN MARINO" = 428,
                                          "SUECIA" = 429,
                                          "SUIZA" = 430,
                                          "SANTA SEDE (VATICANO)" = 431,
                                          "TERRITORIOS VINCULADOS AL REINO UNIDO" = 433,
                                          "CHIPRE" = 435,
                                          "TURQUIA" = 436,
                                          "REPUBLICA FEDERAL DE ALEMANIA" = 438,
                                          "BIELORUS" = 439,
                                          "ESTONIA" = 440,
                                          "LETONIA" = 441,
                                          "LITUANIA" = 442,
                                          "MOLDOVA" = 443,
                                          "RUSIA" = 444,
                                          "UCRANIA" = 445,
                                          "BOSNIA HERZEGOVINA" = 446,
                                          "CROACIA" = 447,
                                          "ESLOVAQUIA" = 448,
                                          "ESLOVENIA" = 449,
                                          "MACEDONIA" = 450,
                                          "REPUBLICA CHECA" = 451,
                                          "YUGOESLAVIA (SERBIA , MONTENEGRO)" = 452,
                                          "RESTO (EUROPA)" = 497,
                                          "INDETERMINADO (EUROPA)" = 498,
                                          "SIN DECLARAR-DESCONOCIDO-IGNORADO (EUROPA)" = 499,
                                          "AUSTRALIA" = 501,
                                          "NAURU" = 503,
                                          "NUEVA ZELANDA" = 504,
                                          "VANUATU" = 505,
                                          "SAMOA  OCCIDENTAL" = 506,
                                          "TERRITORIOS VINCULADOS A AUSTRALIA" = 507,
                                          "TERRITORIOS VINCULADOS AL REINO UNIDO" = 508,
                                          "TERRITORIOS VINCULADOS A FRANCIA" = 509,
                                          "TERRITORIOS VINCULADOS A NUEVA ZELANDA" = 510,
                                          "TERRITORIOS VINCULADOS A ESTADOS UNIDOS" = 511,
                                          "FIJI" = 512,
                                          "PAPUA NUEVA GUINEA" = 513,
                                          "KIRIBATI" = 514,
                                          "MICRONESIA ESTADOS FEDERADOS" = 515,
                                          "PALAU" = 516,
                                          "TUVALU" = 517,
                                          "ISLAS SALOMON" = 518,
                                          "TONGA" = 519,
                                          "ISLAS MARSHALL" = 520,
                                          "ISLAS MARIANAS" = 521,
                                          "RESTO (OCEANIA)" = 597,
                                          "INDETERMINADO (OCEANIA)" = 598,
                                          "SIN DECLARAR-DESCONOCIDO-IGNORADO (OCEANIA)" = 599,
                                          "RESTO" = 997,
                                          "INDETERMINADO (CONTINENTE)" = 998,
                                          "No Sabe Pais / Provincia / Sin declarar-desconocido-ignorado (continente)" = 999),
                             CH16 = 'Donde vivia hace 5 anios?',
                             CH16 = c("En esta localidad" = 1,
                                      "En otra localidad de esta provincia" = 2,
                                      "En otra provincia (especificar)" = 3,
                                      "En un pais limitrofe (especificar Brasil, Bolivia, Chile, Paraguay, Uruguay)" = 4,
                                      "En otro pais (especificar)" = 5,
                                      "No habia nacido" = 6,
                                      "Ns./Nr.." = 9),
                             CH16_COD = 'Especificar',
                             CH16_COD = c("En otra provincia" = 3,
                                          "En un pais limitrofe" = 4,
                                          "En otro pais." = 5),
                             NIVEL_ED = 'Nivel Educativo',
                             NIVEL_ED = c("Primaria incompleta (incluye educacion especial)" = 1,
                                          "Primaria completa" = 2,
                                          "Secundaria incompleta" = 3,
                                          "Secundaria completa" = 4,
                                          "Superior universitaria incompleta" = 5,
                                          "Superior universitaria completa" = 6,
                                          "Sin instruccion" = 7,
                                          "Ns./Nr.." = 9),
                             ESTADO = 'Condicion de actividad',
                             ESTADO = c("Entrevista individual no realizada (no respuesta al cuestionario individual)" = 0,
                                        "Ocupado" = 1,
                                        "Desocupado" = 2,
                                        "Inactivo" = 3,
                                        "Menor de 10 anios." = 4),
                             CAT_OCUP = 'Categoria ocupacional',
                             CAT_OCUP = c("Patron" = 1,
                                          "Cuenta propia" = 2,
                                          "Obrero o empleado" = 3,
                                          "Trabajador familiar sin remuneracion" = 4,
                                          "Ns./Nr.." = 9),
                             CAT_INAC = 'Categoria de inactividad',
                             CAT_INAC = c("Jubilado / pensionado" = 1,
                                          "Rentista" = 2,
                                          "Estudiante" = 3,
                                          "Ama de casa" = 4,
                                          "Menor de 6 anios" = 5,
                                          "Discapacitado" = 6,
                                          "Otros." = 7),
                             IMPUTA = 'Indica los casos que han sido imputados',
                             PP02C1 = 'De Que manera estuvo buscando trabajo? - Hizo contactos, entrevistas',
                             PP02C1 = c("Si" = 1,
                                        "No" = 2),
                             PP02C2 = 'De Que manera estuvo buscando trabajo? - Mando curriculum, puso o contesto avisos',
                             PP02C2 = c("Si" = 1,
                                        "No" = 2),
                             PP02C3 = 'De Que manera estuvo buscando trabajo? - Se presento en establecimientos',
                             PP02C3 = c("Si" = 1,
                                        "No" = 2),
                             PP02C4 = 'De Que manera estuvo buscando trabajo? - Hizo algo para ponerse por su cuenta',
                             PP02C4 = c("Si" = 1,
                                        "No" = 2),
                             PP02C5 = 'De Que manera estuvo buscando trabajo? - Puso carteles en negocios, pregunto en el barrio',
                             PP02C5 = c("Si" = 1,
                                        "No" = 2),
                             PP02C6 = 'De Que manera estuvo buscando trabajo? - Consulto a parientes, amigos',
                             PP02C6 = c("Si" = 1,
                                        "No" = 2),
                             PP02C7 = 'De Que manera estuvo buscando trabajo? - Se anioto en bolsas, listas, planes de empleo, agencias, contratistas o alguien le estpa buscando trabajo',
                             PP02C7 = c("Si" = 1,
                                        "No" = 2),
                             PP02C8 = 'De Que manera estuvo buscando trabajo? - Busco trabajo de otra forma activa',
                             PP02C8 = c("Si" = 1,
                                        "No" = 2),
                             PP02E = 'Durante esos 30 dias no busCo trabajo, porque...',
                             PP02E = c("esta suspendido" = 1,
                                       "ya tiene trabajo asegurado" = 2,
                                       "se canso de buscar tranajo" = 3,
                                       "hay poco trabajo en esta epoca del anio" = 4,
                                       "por otras razones." = 5),
                             PP02H = 'En los ultimos 12 meses, busco trabajo en algun momento?',
                             PP02H = c("Si" = 1,
                                       "No" = 2),
                             PP02I = 'En los ultimos 12 meses, trabajo en algun momento?',
                             PP02I = c("Si" = 1,
                                       "No" = 2),
                             PP03C = 'La semana pasada, tenia...',
                             PP03C = c("...un solo empleo / ocupacion / actividad?" = 1,
                                       "...mas de un empleo / ocupacion / actividad?." = 2),
                             PP03D = 'Cantidad de ocupaciones.',
                             PP3E_TOT = 'Total de horas que trabajo en la semana en la ocupacion principal',
                             PP3F_TOT = 'Total de horas que trabajo en la semana en otras ocupaciones',
                             PP03G = 'La semana pasada, queria trabajar mas horas?',
                             PP03G = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP03H = 'Si hubiera conseguido mas horas...',
                             PP03H = c("podia trabajarlas esta semana" = 1,
                                       "podia empezar a trabajarlas en dos semanas a mas tardar" = 2,
                                       "no podia trabajar mas horas" = 3,
                                       "Ns./Nr.." = 9),
                             PP03I = 'En los ultimos 30 dias, busco trabajar mas horas?',
                             PP03I = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP03J = 'Aparte de este/os trabajo/s, estuvo buscando algun empleo / ocupacion / actividad?',
                             PP03J = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             INTENSI = 'INTENSI',
                             INTENSI = c("Subocupado por insuficiencia horaria" = 1,
                                         "Ocupado pleno" = 2,
                                         "Sobreocupado" = 3,
                                         "Ocupado que no trabajo en la semana" = 4,
                                         "Ns./Nr.." = 9),
                             PP04A = 'El negocio / empresa / institucion / actividad en la que trabaja es (se refiere al que trabaja mas horas semanales)...',
                             PP04A = c("...estatal" = 1,
                                       "...privada" = 2,
                                       "...de otro tipo" = 3,
                                       "Ns./Nr.." = 9),
                             PP04B_COD = 'A que se dedica o produce el negocio / empresa / institucion?',
                             PP04B1 = 'Si presta servicio domestico en hogares particulares',
                             PP04B1 = c("Casa de familia" = 1),
                             PP04B2 = 'En cuantas casas trabaja?',
                             PP04B3_MES = 'Cuanto tiempo hace que trabaja alli? - MES',
                             PP04B3_ANO = 'Cuanto tiempo hace que trabaja alli? - ANIO',
                             PP04B3_DIA = 'Cuanto tiempo hace que trabaja alli? - DiAS',
                             PP04C = 'Cuantas personas, incluido... trabajan alli en total?',
                             PP04C = c("1 persona" = 1,
                                       "2 personas" = 2,
                                       "3 personas" = 3,
                                       "4 personas" = 4,
                                       "5 personas" = 5,
                                       "6 a 10 personas" = 6,
                                       "11 a 25 personas" = 7,
                                       "26 a 40 personas" = 8,
                                       "de 41 a 100 personas" = 9,
                                       "de 101 a 200 personas" = 10,
                                       "de 201 a 500 personas" = 11,
                                       "mas de 500 personas" = 12,
                                       "Ns./Nr." = 99),
                             PP04C99 = 'Tamanio del establecimiento',
                             PP04C99 = c("hasta 5" = 1,
                                         "de 6 a 40" = 2,
                                         "mas de 40" = 3,
                                         "Ns./Nr.." = 9),
                             PP04D_COD =  'Codigo de ocupacion',
                             PP04G = 'Donde realiza principalmente sus tareas?',
                             PP04G = c("En un local / oficina / establecimiento / neogocio / taller / chacra / finca" = 1,
                                       "En un puesto o kiosko fijo callejero" = 2,
                                       "En vehiculos: bicicleta, moto, autos, barcos, botes (no incluye servicio de transporte)" = 3,
                                       "En vehiculos para transporte de personas y mercaderias -aereo, maritimo, terrestre-" = 4,
                                       "En obras en construccion, de infraestructura, mineria o similares" = 5,
                                       "En esta vivienda (sin lugar exclusivo)" = 6,
                                       "En la vivienda del socio o del patron" = 7,
                                       "En el domicilio / local de los clientes" = 8,
                                       "En la calle, espacios publicos, ambulante, de casa en casa, puesto movil callejero" = 9,
                                       "En otro lugar (especificar)" = 10,
                                       "Ns./Nr." = 99),
                             PP05B2_MES = 'Cuanto tiempo hace que trabaja en ese emPPleo en forma continua? - MES',
                             PP05B2_ANO = 'Cuanto tiempo hace que trabaja en ese emPPleo en forma continua? - ANIO',
                             PP05B2_DIA = 'Cuanto tiempo hace que trabaja en ese emPPleo en forma continua? - DIA',
                             PP05C_1 = 'En ese negocio / empresa / actividad, tiene... maquinarias / equipos?',
                             PP05C_1 = c("Propio (del negocio)" = 1,
                                         "Prestado / alquilado" = 2,
                                         "No tiene" = 3,
                                         "Ns./Nr.." = 9),
                             PP05C_2 = 'En ese negocio / empresa / actividad, tiene... local (incluye kiosko, puesto fijo)?',
                             PP05C_2 = c("Propio (del negocio)" = 1,
                                         "Prestado / alquilado" = 2,
                                         "No tiene" = 3,
                                         "Ns./Nr.." = 9),
                             PP05C_3 = 'En ese negocio / empresa / actividad, tiene... vehiculo?',
                             PP05C_3 = c("Propio (del negocio)" = 1,
                                         "Prestado / alquilado" = 2,
                                         "No tiene" = 3,
                                         "Ns./Nr.." = 9),
                             PP05E = 'Para la actividad del negocio, en los ultimos 3 meses, tuvo que gastar en la compra de materias primas, productos, pagar servicios u otros gastos?',
                             PP05E = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr." = 9),
                             PP05F = 'Ese negocio / empresa / actividad, trabaja habitualmente para...',
                             PP05H = 'Durante cuanto tiempo ha estado trabajando en ese empleo de forma continua? (con interrupciones laborales no mayores a 15 dias)',
                             PP06A = 'En ese negocio / empresa / actividad tiene socios o familiares asociados?',
                             PP06A = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP06C = 'Monto de patrones y cuenta propia sin socios',
                             PP06D = 'Monto de patrones y cuenta propia con socios',
                             PP06E = 'Ese negocio / empresa / actividad...',
                             PP06H = 'Es una actividad familiar?',
                             PP07A = 'Cuanto tiempo hace que esta trabajando en ese empleo en forma continua? (sin interrupccion de la relacion laboral en la misma empresa / negocio / institucion)',
                             PP07C = 'Ese empleo tiene tiempo de finalizacion?',
                             PP07D = 'Por cuanto tiempo es ese trabajo?',
                             PP07E = 'Ese trabajo es...?',
                             PP07F1 = 'En ese trabajo le dan... de comer gratis en el lugar de trabajo',
                             PP07F1 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07F2 = 'En ese trabajo le dan... vivienda?',
                             PP07F2 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07F3 = 'En ese trabajo le dan... algun producto o mercaderia?',
                             PP07F3 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07F4 = 'En ese trabajo le dan... aglun otro beneficio? (automovil, telefono celular, pasajes, etc.)',
                             PP07F4 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07F5 = 'En ese trabajo le dan... no recibe ninguno?',
                             PP07F5 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07G1 = 'En ese trabajo tiene... vacaciones pagas?',
                             PP07G1 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07G2 = 'En ese trabajo tiene... aguinaldo?',
                             PP07G2 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07G3 = 'En ese trabajo tiene... dias pagos por enfermedad?',
                             PP07G3 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07G4 = 'En ese trabajo tiene... obra social?',
                             PP07G4 = c("Si" = 1,
                                        "No" = 2,
                                        "Ns./Nr.." = 9),
                             PP07G_59 = 'En ese trabajo tiene... no tiene ninguno?',
                             PP07G_59 = c("Si" = 1,
                                          "No" = 2,
                                          "Ns./Nr.." = 9),
                             PP07H = 'Por ese trabajo tiene descuento jubilatorio?',
                             PP07H = c("Si" = 1,
                                       "No" = 2),
                             PP07I = 'Aporta por si mismo a algun sistema jubilatorio?',
                             PP07I = c("Si" = 1,
                                       "No" = 2),
                             PP07J = 'El turno habitual de trabajo es...?',
                             PP07J = c("...de dia" = 1,
                                       "...de noche" = 2,
                                       "...de otro tipo (rotativo, dia y noche, guardias con franco." = 3),
                             PP07K = 'Cuando cobra...',
                             PP07K = c("...le dan recibo con sello / membrete / firma del empleador?" = 1,
                                       "...le dan un papel / recibo sin nada?" = 2,
                                       "...entrega una factura?" = 3,
                                       "...no le dan ni entrega nada?" = 4,
                                       "...no cobra, es trabajador sin pago / ad-honorem?." = 5),
                             PP08D1 = 'Cuanto cobro por ese mes por esos conceptos? Monto total de sueldos/jornales, salario familiar, horas extras, otras bonificaciones habituales y tickets, vales o similares',
                             PP08D4 = 'Por el mes de...(mes)....cobro... Monto percibido en tickets.',
                             PP08F1 = 'Cuanto cobro por ese mes de ..(mes)... Monto en pesos cobrado por Comision por venta/produccion.',
                             PP08F2 = 'Cuanto cobro por ese mes de ..(mes)... Monto en pesos cobrado por Propinas.',
                             PP08J1 = 'Cuanto cobro por ese mes de ..(mes)... Monto aguinaldo.',
                             PP08J2 = 'Cuanto cobro por ese mes de ..(mes)... Monto otras bonificaciones no habituales.',
                             PP08J3 = 'Cuanto cobro por ese mes de ..(mes)... Monto retroactivos.',
                             PP09A = 'SOLO OCUPADOS DE: CIUDAD DE BUENOS AIRES.  Partidos del GBA En su ocupacion (o en la de mas horas)trabaja....en ....',
                             PP09A = c("Ciudad de Buenos Aires" = 1,
                                       "Partidos del GBA" = 2,
                                       "Ambos" = 3,
                                       "En otro lugar." = 4),
                             PP09A_ESP = 'Especificar: contiene la descripcion de otro lugar.',
                             PP09B = 'En su ocupacion (o en la de mas horas), trabaja... en esta ciudad?',
                             PP09B = c("Si" = 1,
                                       "No" = 2),
                             PP09C = 'Donde trabaja...?',
                             PP09C = c("En otro lugar de esta provincia" = 1,
                                       "En otra provincia" = 2,
                                       "En otro pais." = 3),
                             PP09C_ESP = 'Descripcion de otro lugar (segun pregunta PP09C).',
                             PP10A = 'Cuanto hace que esta buscando trabajo..?',
                             PP10A = c("Menos de 1 mes" = 1,
                                       "De 1 a 3 meses" = 2,
                                       "Mas de 3 a 6 meses" = 3,
                                       "Mas de 6 a 12 meses" = 4,
                                       "Mas de 1 anio." = 5),
                             PP10C = 'Durante ese tiempo hizo algun trabajo / changa',
                             PP10C = c("Si" = 1,
                                       "No" = 2),
                             PP10D = 'Has trabajdo alguna vez?',
                             PP10D = c("Si" = 1,
                                       "No" = 2),
                             PP10E = 'Cuanto tiempo hace que termino su ultimo trabajo / changa?',
                             PP10E = c("Menos de 1 mes" = 1,
                                       "De 1 a 3 meses" = 2,
                                       "mas de 3 a 6 meses" = 3,
                                       "Mas de 6 a 12 meses" = 4,
                                       "Mas de 1 a 3 anios" = 5,
                                       "Mas de 3 anios." = 6),
                             PP11A = 'El negocio / empresa / institucion / actividad en la que trabaja era...?',
                             PP11A = c("Estatal" = 1,
                                       "Privado" = 2,
                                       "De otro tipo." = 3),
                             PP11B_COD = 'A que se dedicaba o que producia ese negocio/empresa/institucion?',
                             PP11B1 = 'Si prestaba servicios domesticos en hogares particulares,',
                             PP11B1 = c("Casa de familia" = 1),
                             PP11B2_DIA = 'Cuanto tiempo trabajo alli? - DIAS',
                             PP11B2_MES = 'Cuanto tiempo trabajo alli? - MESES',
                             PP11B2_ANO = 'Cuanto tiempo trabajo alli? - ANIOS',
                             PP11C = 'Cuantas personas, inluido ... trabajan alli en total?',
                             PP11C = c("1 persona" = 1,
                                       "2 personas" = 2,
                                       "3 personas" = 3,
                                       "4 personas" = 4,
                                       "5 personas" = 5,
                                       "6 a 10 personas" = 6,
                                       "11 a 25 personas" = 7,
                                       "26 a 40 personas" = 8,
                                       "41 a 100 personas" = 9,
                                       "101 a 200 personas" = 10,
                                       "201 a 500 personas" = 11,
                                       "Mas de 500 personas" = 12,
                                       "Ns./Nr." = 99),
                             PP11C99 = 'Ns./Nr. cuantas personas trabajan alli en total',
                             PP11C99 = c("Hasta 5 personas" = 1,
                                         "De 6 a 40 personas" = 2,
                                         "Mas de 40 personas" = 3,
                                         "Ns./Nr.." = 9),
                             PP11D_COD = 'Como se llamaba la ocupacion que tenia?',
                             PP11G_ANO = 'Cuanto tiempo seguido estuvo trabajando en ese lugar? - ANIO',
                             PP11G_MES = 'Cuanto tiempo seguido estuvo trabajando en ese lugar? - MES',
                             PP11G_DIA = 'Cuanto tiempo seguido estuvo trabajando en ese lugar? - DIA',
                             PP11L = 'Cual fue la razon principal por la que dejo esa actividad?',
                             PP11L = c("falta de clientes/clientes que no pagan" = 1,
                                       "falta de capital/equipamiento" = 2,
                                       "trabajo estacional" = 3,
                                       "tenia gastos demasiado altos" = 4,
                                       "otras causas laborales (especificar)" = 5,
                                       "jubilacion/retiro" = 6,
                                       "causas personales (matrimonio, embarazo cuidado de hijos o familiar, estudio, enfermedad)." = 7),
                             PP11L1 = 'Ese trabajo era...',
                             PP11L1 = c("...una changa, trabajo transitorio, por tarea u obra, suplencia, etc?" = 1,
                                        "...un trabajo permanente, fijo, estable, de planta, etc.?" = 2,
                                        "Ns./Nr.." = 3),
                             PP11M = 'Ese trabajo era...',
                             PP11M = c("...un plan de empleo?" = 1,
                                       "...un periodo de prueba?" = 2,
                                       "...otro tipo de trabajo?" = 3),
                             PP11N = 'En ese trabajo lehacian descuento jubilatorio?',
                             PP11N = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP11O = 'Cual fue la razon principal por la que dejo ese trabajo?',
                             PP11O = c("Despido / cierre (quiebre/venta/traslado de la empresa/reestructuracion o recorte de personal/falta de ventas o clientes" = 1,
                                       "Por retiro voluntario del sector publico" = 2,
                                       "Por jubilacion" = 3,
                                       "Fin de tranajo temporario / estacional" = 4,
                                       "Le pagaban poco / no le pagaban" = 5,
                                       "Malas relaciones laborales / malas condiciones de trabajo (insalubre, cambios de horarios, etc.)" = 6,
                                       "Renuncia obligada / pactada" = 7,
                                       "Otras causas laborales" = 8,
                                       "Por razones personales (matrimonio, embarazo, cuidado de hijos o la familia, estudio, enfermedad)." = 9),
                             PP11P = 'Cerro la empresa?',
                             PP11P = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP11Q =  'Fue la unica persona que quedo sin trabajo?',
                             PP11Q = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             PP11R = 'Le enviaron telegrama?',
                             PP11R = c("Si" = 1,
                                       "No" = 2),
                             PP11S = 'Le pagaron indemnizacion?',
                             PP11S = c("Si" = 1,
                                       "No" = 2),
                             PP11T = 'Esta cobrando seguro de desempleo?',
                             PP11T = c("Si" = 1,
                                       "No" = 2,
                                       "Ns./Nr.." = 9),
                             P21 = 'MONTO DE INGRESO DE LA OCUPACIoN PRINCIPAL.',
                             DECOCUR = 'Nro de decil de ingreso de la ocupacion principal del TOTAL EPH.',
                             IDECOCUR = 'Nro de decil de ingreso de la ocupacion principal del INTERIOR EPH',
                             RDECOCUR = 'Nro de decil de ingreso de la ocupacion principal de la REGION',
                             GDECOCUR = 'Nro de decil de ingreso de la ocupacion principal del CONJUNTO DE AGLOMERADOS DE 500 MIL Y MAS HABITANTES',
                             PDECOCUR = 'Nro de decil de ingreso de la ocupacion principal del CONJUNTO DE AGLOMERADOS DE MENOS DE 500 MIL HABITANTES',
                             ADECOCUR = 'Nro de decil de ingreso de la ocupacion principal del AGLOMERADO.',
                             PONDIIO = 'Ponderador del ingreso de la ocupacion principal.',
                             TOT_P12 = 'MONTO DE INGRESO DE OTRAS OCUPACIONES. (Incluye: ocupacion secundaria, ocupacion previa a la semana de referencia, deudas/retroactivos por ocupaciones anteriores al mes de referencia, etc).',
                             P47T = 'MONTO DE INGRESO TOTAL INDIVIDUAL(sumatoria ingresos laborales y no laborales).',
                             DECINDR = 'Nro de decil de ingreso total individual del TOTAL EPH.',
                             IDECINDR = 'Nro de decil de ingreso total individual del INTERIOR EPH.',
                             RDECINDR = 'Nro de decil de ingreso total individual de la REGION.',
                             GDECINDR = 'Nro de decil de ingreso total individual del CONJUNTO DE AGLOMERADOS DE 500 MIL Y MAS HABITANTES.',
                             PDECINDR = 'Nro de decil de ingreso total individual del CONJUNTO DE AGLOMERADOS DE MENOS DE 500 MIL HABITANTES.',
                             ADECINDR = 'Nro de decil de ingreso total individual del AGLOMERADO.',
                             PONDII = 'Ponderador para ingreso total individual.',
                             V2_M = 'Monto del ingreso por JUBILACION O PENSION.',
                             V3_M = 'Monto del ingreso por INDEMNIZACION POR DESPIDO.',
                             V4_M = 'Monto del ingreso por SEGURO DE DESEMPLEO.',
                             V5_M = 'Monto del ingreso por SUBSIDIO O AYUDA SOCIAL (EN DINERO) DEL GOBIERNO, IGLESIAS, ETC.',
                             V8_M = 'Monto del ingreso por ALQUILER (VIVIENDA , TERRENO, OFICINA, ETC.) DE SU PROPIEDAD.',
                             V9_M = 'Monto del ingreso por GANANCIAS DE ALGUN NEGOCIO EN EL QUE NO TRABAJo.',
                             V10_M = 'Monto del ingreso por INTERESES O RENTAS POR PLAZOS FIJOS/INVERSIONES.',
                             V11_M = 'Monto del ingreso por BECA DE ESTUDIO.',
                             V12_M = 'Monto del ingreso por CUOTAS DE ALIMENTOS O AYUDA EN DINERO DE PERSONAS QUE NO VIVEN EN EL HOGAR.',
                             V18_M = 'Monto del ingreso por OTROS INGRESOS EN EFECTIVO (LIMOSNAS, JUEGOS DE AZAR, ETC.).',
                             V19_AM = 'Monto del ingreso por TRABAJO DE MENORES DE 10 ANIOS.',
                             V21_M = 'Monto del ingreso por aguinaldo.',
                             T_VI = 'MONTO TOTAL DE INGRESOS NO LABORALES',
                             ITF = 'MONTO DEL INGRESO TOTAL FAMILIAR.',
                             DECIFR = 'Nro de decil de ingreso total familiar del TOTAL.',
                             IDECIFR = 'Nro de decil de ingreso total familiar del INTERIOR.',
                             RDECIFR = 'Nro de decil de ingreso total familiar de la REGION.',
                             GDECIFR = 'Nro de decil de ingreso total familiar del CONJUNTO DE AGLOMERADOS DE 500 MIL Y MAS HABITANTES.',
                             PDECIFR = 'Nro de decil de ingreso total familiar del CONJUNTO DE AGLOMERADOS DE MENOS DE 500 MIL HABITANTES.',
                             ADECIFR = 'Nro de decil de ingreso total familiar del AGLOMERADO (ver Anexo I).',
                             IPCF = 'MONTO DEL INGRESO PER CAPITA FAMILIAR.',
                             DECCFR = 'Nro de decil de ingreso per capita familiar del TOTAL EPH (ver Anexo I).',
                             IDECCFR = 'Nro de decil de ingreso per capita familiar del  INTERIOR EPH (ver Anexo I).',
                             RDECCFR = 'Nro de decil de ingreso per capita familiar de la REGION.',
                             GDECCFR = 'Nro de decil de ingreso per capita familiar del CONJUNTO DE AGLOMERADOS DE 500 MIL Y MAS HABITANTES.',
                             PDECCFR = 'Nro de decil de ingreso per capita familiar del CONJUNTO DE AGLOMERADOS DE MENOS DE 500 MIL HABITANTES.',
                             ADECCFR = 'Nro de decil de ingreso per capita familiar del AGLOMERADO.',
                             PONDIH = 'Ponderador del ingreso total familiar y del ingreso per capita familiar, para hogares.')
  }
  else{
    stop("couldn't tagg")
  }

}
