% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatiotemporal.R
\name{morans_index}
\alias{morans_index}
\title{Calculate spatial correlation of given municipalities in an incidence_rate
object.}
\usage{
morans_index(
  incidence_object,
  scale = 1e+05,
  threshold = 2,
  plot = TRUE,
  language = c("EN", "ES")
)
}
\arguments{
\item{incidence_object}{An incidence object with one observation for the
different locations (groups).}

\item{scale}{Scale to consider when calculating the incidence_rate.}

\item{threshold}{Maximum traveling time around each municipality.}

\item{plot}{if TRUE, returns a plot of influential observations in the
Moran's plot.}

\item{language}{Language for plot components}
}
\value{
List of Moran's I clustering analysis, giving the quadrant of each
observation, influential values.
}
\description{
Function to calculate spatial autocorrelation via Moran's Index
from a given incidence_rate object grouped by municipality.
}
\examples{
data_event <- epiCo::epi_data
incidence_historic <- incidence::incidence(data_event$fec_not,
  groups = data_event$cod_mun_o,
  interval = "4 year"
)
incidence_object <- subset(incidence_historic,
  from = "2015-01-04",
  to = "2018-12-27"
)
morans_index(incidence_object, scale = 100000, threshold = 2, plot = TRUE)
}
