% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{merge_cluster}
\alias{merge_cluster}
\title{Merges a number of clusters around the target}
\usage{
merge_cluster(clusters, center, k = 3)
}
\arguments{
\item{clusters}{vector of cluster memberships. Typically, the output
of \code{\link[stats]{cutree}}}

\item{center}{the target variant cluster}

\item{k}{vector or integer. if \code{k} is given as a vector, it corresponds to
the cluster indices to be updated. Otherwise, if \code{k} is an integer,
the cluster indices to be updated lie between \code{center-k} and
\code{center+k}.}
}
\value{
The updated cluster membership vector. The cluster indexing is also
  updated so that the maximum cluster index is equal to the total number of
  clusters after merging.
}
\description{
The purpose of the function \code{\link{merge_cluster}} is to
define an enlarged window of SNPs which
are in linkage disequilibrium with the target. It replaces the indices of neighbor
clusters with \code{center}, the target cluster index. The neighborhood is defined
according to the parameter \code{k} (see Arguments for more details). Subsequently,
we filter them out for the estimate of the propensity scores.
}
\examples{
hc <- hclust(dist(USArrests))
clusters <- cutree(hc, k = 10)
merge_cluster(clusters, center=5, k=2)

}
