% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_id.R
\name{get_id}
\alias{get_id}
\title{Access unique identifiers in epicontacts objects}
\usage{
get_id(x, which = c("linelist", "contacts", "all", "common", "from", "to"))
}
\arguments{
\item{x}{an \code{\link{epicontacts}} object}

\item{which}{the type of ID to return (see description); value can be
'linelist', 'contacts', 'all', 'common', 'from' or 'to'.}
}
\value{
x a character vector of unique identifiers
}
\description{
This accessor is used to extract unique identifiers from
\code{\link{epicontacts}} objects. The argument 'which' can be used to
specify if IDs should include: linelist only ('linelist'), contacts only
('contacts'), the union of both ('all'), or the intersection of both
('common'); two additional options are 'from' (ID 'giving' contacts) and 'to'
(ID 'receiving' contacts).
}
\examples{

if (require(outbreaks)) {
## build data
x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                       id="case_id", to="case_id", from="infector",
                       directed=TRUE)

## get identifiers
id1 <- get_id(x, "linelist")
id2 <- get_id(x, "contacts")
id3 <- get_id(x, "all")
id4 <- get_id(x, "common")

## check intersections and unions
all.equal(union(id1, id2), id3)
all.equal(intersect(id1, id2), id4)

}

}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
