% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_paho_dengue}
\alias{pub_paho_dengue}
\title{PAHO Dengue data}
\usage{
pub_paho_dengue(
  regions,
  epiweeks,
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Regions to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/paho_dengue.html}
}
\examples{
\dontrun{
pub_paho_dengue(regions = "ca", epiweeks = epirange(201401, 201501))
}
}
\keyword{endpoint}
