% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strscan.R
\name{strscan}
\alias{strscan}
\title{Extract words from a string vector.}
\usage{
strscan(src, delimiter, pos)
}
\arguments{
\item{src}{a source string vector to be split.}

\item{delimiter}{a delimiter string.}

\item{pos}{a subset indicator vector to select.}
}
\value{
a string vector to be extracted.
}
\description{
This function split a string into several string components divided by delimiter, and devided components selected by position are returned.
}
\examples{
bdate <- c("3/21/1941", "9/21/1919", "6/1/1951")
datestr <- paste(strscan(bdate, "/", 3), strscan(bdate, "/", 1), strscan(bdate, "/", 2),
                 sep="-")
datestr
as.Date(bdate, '\%m/\%d/\%Y')
}

