% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqtl.R
\name{pqtl_list}
\alias{pqtl_list}
\title{Return a list of all proteins/exposures or traits/outcomes
available in the database}
\usage{
pqtl_list(flag = c("exposures", "outcomes"), mode = c("table", "raw"))
}
\arguments{
\item{flag}{(Optional) A flag which indicates whether the list of
exposures (if "exposures") or outcomes (if "outcomes")
should be returned. The DEFAULT is "exposures".}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \verb{GET /pqtl/list/}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-pqtllist}{\verb{GET /pqtl/list/}}
}
\examples{

# Returns a list of available proteins (exposures)
pqtl_list()

# Returns a list of available traits (outcomes)
pqtl_list(flag = "outcomes")
}
