% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetic_cor.R
\name{genetic_cor}
\alias{genetic_cor}
\title{Genetic correlations between traits}
\usage{
genetic_cor(trait, cor_coef_threshold = 0.8, mode = c("table", "raw"))
}
\arguments{
\item{trait}{name of the trait, e.g. "body mass index"}

\item{cor_coef_threshold}{correlation coefficient threshold}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \code{GET /genetic_cor}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-genetic-cor}{\code{GET /genetic-cor}}
}
\examples{
genetic_cor(trait = "Body mass index") \%>\%
  dplyr::glimpse()

# Use a different threshold
genetic_cor(trait = "Body mass index", cor_coef_threshold = 0.4) \%>\%
  dplyr::glimpse()
}
