% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{retrospec}
\alias{retrospec}
\title{Function to predict efficacy of outbreak-response vaccination campaign}
\usage{
retrospec(R, day, vaccine_efficacy, target_vaccination,
  intervention_length, mtime, LP = 7, IP = 7, N = 10000)
}
\arguments{
\item{R}{reproductive ratio}

\item{day}{first day of ORV campaign}

\item{vaccine_efficacy}{Vaccine efficacy}

\item{target_vaccination}{fraction of population vaccinated during ORV campaign}

\item{intervention_length}{duration of ORV campaign}

\item{mtime}{length of simulation}

\item{LP}{length of latent period}

\item{IP}{length of infectious period}

\item{N}{initial susceptible population size}
}
\value{
A list of gradients
}
\description{
Function to predict efficacy of outbreak-response vaccination campaign
}
\examples{
red1=retrospec(R=1.8, 161, vaccine_efficacy=0.85, target_vaccination=0.5, 
 intervention_length=10, mtime=250, LP=8, IP=5, N=16000)
1-red1$redn
}
