% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatsir.R
\name{gravity}
\alias{gravity}
\title{A function to calculate the matrix of gravity coupling based on distance and population size}
\usage{
gravity(tau1, tau2, rho, pop, distance)
}
\arguments{
\item{tau1}{recipient exponent}

\item{tau2}{donor exponent}

\item{rho}{distance exponent}

\item{pop}{a vector of population sizes}

\item{distance}{a matrix of distances}
}
\value{
A matrix of gravity coupling
}
\description{
A function to calculate the matrix of gravity coupling based on distance and population size
}
\examples{
require(ncf)
data(usflu)
usdist = gcdist(usflu$Longitude, usflu$Latitude)
G = gravity(0.3, 0.6, 3, usflu$Pop, usdist)
}
\seealso{
\code{\link{sirSpatmod}}
}
