% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_params.R
\name{.convert_params_gamma}
\alias{.convert_params_gamma}
\title{Convert parameters of the gamma distribution to summary statistics}
\usage{
.convert_params_gamma(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{Numeric} named parameter(s)
used to convert to summary statistics. An example is the \code{meanlog} and
\code{sdlog} parameters of the lognormal (\code{lnorm}) distribution.}
}
\value{
A list of eight elements including: mean, median, mode,
variance (\code{var}), standard deviation (\code{sd}), coefficient of variation (\code{cv}),
skewness, and excess kurtosis (\code{ex_kurtosis}).
}
\description{
Convert the shape and scale parameters of the gamma
distribution to a number of summary statistics which can be calculated
analytically given the gamma parameters. One exception is the median which
is calculated using \code{\link[=qgamma]{qgamma()}} as no analytical form is available.
}
\keyword{internal}
