% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{as.data.frame.intensity}
\alias{as.data.frame.intensity}
\title{Coerce to a data frame.}
\usage{
\method{as.data.frame}{intensity}(x, row.names = NULL, optional = FALSE,
  ..., stringsAsFactors = default.stringsAsFactors())
}
\arguments{
\item{x}{An \code{intensity} object.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link{data.frame}(*, check.names = !optional)}.}

\item{...}{additional arguments to be passed to or from methods.}

\item{stringsAsFactors}{logical: should the character vector be converted
    to a factor?}
}
\value{
A data frame.
}
\description{
Functions to coerce an \code{intensity} object to a data frame.
}
\examples{
my_data <- incidence(tomato_tswv$field_1929)
head(as.data.frame(my_data))

}
