\name{expepi}
\alias{expepi}
\title{
Fit density estimate by exponential epi-splines.
}
\description{
This code produces one-dimensional density estimates satisfying 
"soft" conditions like unimodality. A number of possible soft conditions
are permitted. This version calls the nloptr suite of optimizers. Convergence
is not particularly fast.
}
\usage{
expepi(data, lower = NULL, upper = NULL, N = 10, M = 5, 
 order = 2, softinfo, opt.args, opt.local.args, postproc.controls)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
Numeric vector of data for density estimate.
}
  \item{lower}{
Lower bound for density support. If missing, use default as set in 
\code{\link{preprocess.data}}
}
  \item{upper}{
Upper bound for density support. If missing, use default as set in 
\code{\link{preprocess.data}}}
  \item{N}{
Integer: number of segments. Default 10.
}
  \item{M}{
Integer: number of points within each segment to consider. Default 5.
}
  \item{order}{
Integer: order of polynomials used in spline fits. Currently this must be 2.
}
  \item{softinfo}{
List of "soft" conditions to be imposed on the density estimate. See
\code{\link{setup.softinfo}} for possibilities.
}
  \item{opt.args}{
List of arguments to be passed to global optimizer. See 
\code{\link{setup.optargs}} for defaults and more information.
Set \code{print_level = 1} to show each iteration in the global
optimizer, which might help convince you that something is happening.
}
  \item{opt.local.args}{
List of arguments to be passed to local optimizer. See 
\code{\link{setup.optargs}} for defaults and more information.
}
  \item{postproc.controls}{
List of arguments for post-processing. See
\code{\link{postproc.control}} for defaults and more information.
}
}
\details{
This function produces a density estimator for data \code{data}, imposing
constraints in \code{softinfo}. The density is in the form of an 
exponential epi-spline. An epi-spline is like a spline estimator in that
in consists of polynomials between knots. However, the polynomials are not
automatically constrained to meet at knots.  The density estimate is an
exponential epi-spline,  which is \code{exp(- s)} where \code{s} is the
epi-spline value.
}
\value{
A list of class \code{c("episplineDensity", "nloptr")} with the output 
from nloptr, plus additional items:
\item{softinfo }{The softinfo as passed to the optimizer, consisting of
    what was passed into this function plus some defaults}
\item{epiparameters }{Epiparameters, as generated by 
    \code{\link{preprocess.data}}}
\item{caseinfo }{A list with the sample size, as \code{sampleisze}, and
    notion else.}
\item{x }{Copy of the data}
\item{c.out }{Coefficients associated with this set of data.}
\item{opts }{Copy of opts. See \code{\link{setup.optargs}}.}
\item{orig.integral }{If the postprocessing option \code{normalize.to.1} is
supplied, this item is present and gives the value of the integral
of the density before normalization. It should be near 1.}
\item{integral }{If the postprocessing option \code{normalize.to.1} is
supplied, this item is present and gives the value of the integral
of the density after normalization. It should exactly 1.}
}
\references{
Royset and Wets, Nonparametric Density Estimation with Soft Information
Using Exponential Epi-Splines, in press.
}
\author{
Sam Buttrey, after Matlab code from Royset and Wets.
}

\seealso{\code{\link{nloptr}}}

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

n10 <- c(-0.795173769, -0.268865287, -0.032803042, -0.361751212, 
0.699170399, -0.909275685, 0.452956532, 1.501356616, 1.669061521, 
-0.524919503)
#
# Generate a unimodal estimate. Plot automatically.
#
\dontrun{soft <- setup.softinfo (10, unimodal = TRUE)}

\dontrun{expepi (n10, softinfo = soft)}
#
# Generate a unimodal estimate, but constrain the second non-central
# moment to be <= 0.4. Plot automatically. This command will require
# a couple of minutes to run.
#
\dontrun{soft$upperbound2moment <- 0.4}
\dontrun{expepi (n10, softinfo = soft)}
#
# Generate a nondecreasing estimate without plotting.
#
\dontrun{soft <- setup.softinfo (10, monotone="nondecreasing")}
\dontrun{n10.out <- expepi (n10, softinfo = soft, postproc.controls = 
 postproc.control (pic.types = NULL))}
#
# Now plot.
#
\dontrun{plot (n10.out)}
}
