% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSEIRDCONN.R
\name{ModelSEIRDCONN}
\alias{ModelSEIRDCONN}
\alias{epiworld_seirdconn}
\alias{plot.epiworld_seirdconn}
\title{Susceptible Exposed Infected Removed Deceased model (SEIRD connected)}
\usage{
ModelSEIRDCONN(
  name,
  n,
  prevalence,
  contact_rate,
  transmission_rate,
  incubation_days,
  recovery_rate,
  death_rate
)

\method{plot}{epiworld_seirdconn}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus.}

\item{n}{Number of individuals in the population.}

\item{prevalence}{Initial proportion of individuals with the virus.}

\item{contact_rate}{Numeric scalar. Average number of contacts per step.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Probability of
transmission.}

\item{incubation_days}{Numeric scalar greater than 0. Average number of
incubation days.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Probability of recovery_rate.}

\item{death_rate}{Numeric scalar between 0 and 1. Probability of death.}

\item{x}{Object of class SEIRCONN.}

\item{main}{Title of the plot.}

\item{...}{Currently ignore.}
}
\value{
\itemize{
\item The \code{ModelSEIRDCONN}function returns a model of class \link{epiworld_model}.
}

The \code{plot} function returns a plot of the SEIRDCONN model of class
\link{epiworld_model}.
}
\description{
The SEIRD connected model implements a model where all agents are connected.
This is equivalent to a compartmental model (\href{https://en.wikipedia.org/w/index.php?title=Compartmental_models_in_epidemiology&oldid=1155757336#The_SEIR_model}{wiki}).
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. The user must provide a vector of proportions indicating the following
values: (1) Proportion of exposed agents who are infected, (2)
proportion of non-infected agents already removed, and (3) proportion of
non-ifected agents already deceased.
}
\examples{
# An example with COVID-19
model_seirdconn <- ModelSEIRDCONN(
  name                = "COVID-19",
  prevalence          = 0.01, 
  n                   = 10000,
  contact_rate        = 2, 
  incubation_days     = 7, 
  transmission_rate   = 0.5,
  recovery_rate       = 0.3,
  death_rate          = 0.01
)
  
# Running and printing
run(model_seirdconn, ndays = 100, seed = 1912)
model_seirdconn

plot(model_seirdconn)

# Adding the flu
flu <- virus(
  "Flu", prob_infecting = .3, recovery_rate = 1/7,
  prob_death = 0.001,
  prevalence = 0.001, as_proportion = TRUE
)
add_virus(model = model_seirdconn, virus = flu)

#' # Running and printing
run(model_seirdconn, ndays = 100, seed = 1912)
model_seirdconn

plot(model_seirdconn)
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
