% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease_dispersal.r
\name{disease_dispersal}
\alias{disease_dispersal}
\title{Nested functions for population dispersal in a disease ecology simulation.}
\usage{
disease_dispersal(
  replicates,
  time_steps,
  populations,
  demographic_stochasticity,
  dispersal,
  dispersal_type,
  dispersal_source_n_k = NULL,
  dispersal_target_k = NULL,
  dispersal_target_n = NULL,
  dispersal_target_n_k = NULL,
  stages = NULL,
  compartments = NULL,
  simulator
)
}
\arguments{
\item{replicates}{Number of replicate simulation runs.}

\item{time_steps}{Number of simulation time steps.}

\item{populations}{Number of populations.}

\item{demographic_stochasticity}{Boolean for optionally choosing demographic
stochasticity for the transformation.}

\item{dispersal}{Must be a list. Either a list of matrices of dispersal rates
between populations (source columns to target rows) or a list of data
frames of non-zero dispersal rates and indices for constructing a compact
dispersal matrix, and optionally a list of lists of data frames showing
changing rates over time (as per class \code{\link[poems:DispersalGenerator]{poems::DispersalGenerator}}
\emph{dispersal_data} attribute). Alternatively a list of user-defined
functions may be used: \code{function(params)}, where \emph{params} is a
list passed to the function containing:
\describe{
\item{\code{replicates}}{Number of replicate simulation runs.}
\item{\code{time_steps}}{Number of simulation time steps.}
\item{\code{populations}}{Number of populations.}
\item{\code{stages}}{Number of life cycle stages.}
\item{\code{compartments}}{Number of disease compartments.}
\item{\code{dispersal_type}}{Must be "pooled", "stages", "compartments", or "segments". This indicates whether dispersal should be handled differently by stage and/or compartment.}
\item{\code{demographic_stochasticity}}{Boolean for optionally choosing demographic stochasticity for the transformation.}
\item{\code{dispersal_source_n_k}}{Dispersal proportion (p) density dependence via source population abundance divided by carrying capacity (n/k), where p is reduced via a linear slope (defined by two list items) from n/k <= \emph{cutoff} (p = 0) to n/k >= \emph{threshold}.}
\item{\code{dispersal_target_k}}{Dispersal rate (r) density dependence via target population carrying capacity (k), where r is reduced via a linear slope (through the origin) when k <= \emph{threshold}.}
\item{\code{dispersal_target_n}}{Dispersal rate (r) density dependence via target population abundance (n), where r is reduced via a linear slope (defined by two list items) from n >= \emph{threshold} to n <= \emph{cutoff} (r = 0) or vice versa.}
\item{\code{dispersal_target_n_k}}{Dispersal rate (r) density dependence via target population abundance divided by carrying capacity (n/k), where r is reduced via a linear slope (defined by two list items) from n/k >= \emph{threshold} to n/k <= \emph{cutoff} (r = 0) or vice versa.}
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values for each population at time step.}
\item{\code{segment_abundance}}{Matrix of abundance for each stage by compartment (rows) and population (columns) at time step.}
\item{\code{simulator}}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object with dynamically accessible \emph{attached} and \emph{results} lists.}
}
returns the post-dispersal abundance matrix}

\item{dispersal_type}{Must be "pooled", "stages", "compartments", or
"segments". This indicates whether dispersal should be handled differently
by stage and/or compartment.}

\item{dispersal_source_n_k}{Dispersal proportion (p) density dependence via
source population abundance divided by carrying capacity (n/k), where p is
reduced via a linear slope (defined by two list items) from n/k <=
\emph{cutoff} (p = 0) to n/k >= \emph{threshold} or vice versa.}

\item{dispersal_target_k}{Dispersal rate (r) density dependence via target
population carrying capacity (k), where r is reduced via a linear slope
(through the origin) when k <= \emph{threshold}.}

\item{dispersal_target_n}{Dispersal rate (r) density dependence via target
population abundance (n), where r is reduced via a linear slope (defined by
two list items) from n >= \emph{threshold} to n <= \emph{cutoff} (r = 0) or
visa-versa.}

\item{dispersal_target_n_k}{Dispersal rate (r) density dependence via target
population abundance divided by carrying capacity (n/k), where r is reduced
via a linear slope (defined by two list items) from n/k >= \emph{threshold}
to n/k <= \emph{cutoff} (r = 0) or vice versa.}

\item{stages}{Number of life cycle stages.}

\item{compartments}{Number of disease compartments.}

\item{simulator}{\code{\link[poems:SimulatorReference]{poems::SimulatorReference}} object with dynamically
accessible \emph{attached} and \emph{results} lists.}
}
\value{
Dispersal function: \code{function(r, tm, carrying_capacity,
  segment_abundance)}, where:
\describe{
\item{\code{r}}{Simulation replicate.}
\item{\code{tm}}{Simulation time step.}
\item{\code{carrying_capacity}}{Array of carrying capacity values for each population at time step.}
\item{\code{segment_abundance}}{Matrix of abundance for each stage by compartment (rows) and population (columns) at time step.}
\item{\code{returns}}{New stage abundance matrix with dispersal applied.}
}
}
\description{
Modular functions for the disease simulator for performing dispersal of
segment (stage by compartment) abundance at a specified time step via
dispersal rates provided. Dispersal can be handled identically for all stages
and compartments, or can be handled differently by stage, compartment, or
both.
}
