% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{expand_idf_dots_object}
\alias{expand_idf_dots_object}
\title{Parse object values given in a list of Idf or IdfObject format}
\usage{
expand_idf_dots_object(
  idd_env,
  idf_env,
  ...,
  .unique = TRUE,
  .strict = TRUE,
  .complete = TRUE,
  .all = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{...}{Lists of \link{Idf}s or \link{IdfObject}s.}

\item{.unique}{If \code{TRUE}, make sure there are no duplicated objects in the
input. If \code{FALSE}, duplicates are kept. If \code{NULL}, duplicates are
removed. Default: \code{TRUE}.}

\item{.strict}{If \code{TRUE}, make sure all input objects come from the same
version as that from \code{idf_env}. Default: \code{TRUE}.}

\item{.complete}{If \code{TRUE}, make sure the returned field number meets the
\verb{\\min-fields} requirement. Default: \code{TRUE}}

\item{.all}{If \code{TRUE}, make sure the all possible fields are returned.
Default: \code{FALSE}.}
}
\value{
A named list of 3 \code{\link[data.table:data.table]{data.table::data.table()}}: \code{meta}, \code{object} and
\code{value}.
}
\description{
Parse object values given in a list of Idf or IdfObject format
}
\keyword{internal}
