% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{path_eplus}
\alias{path_eplus}
\alias{path_eplus_processor}
\alias{path_eplus_example}
\alias{path_eplus_weather}
\alias{path_eplus_dataset}
\title{Get file path from EnergyPlus installation directory}
\usage{
path_eplus(ver, ..., strict = FALSE)

path_eplus_processor(ver, ..., strict = FALSE)

path_eplus_example(ver, file, strict = FALSE)

path_eplus_weather(ver, file, strict = FALSE)

path_eplus_dataset(ver, file, strict = FALSE)
}
\arguments{
\item{ver}{An acceptable EnergyPlus version or an EnergyPlus installation
directory}

\item{...}{File paths passed to \code{\link[base:file.path]{base::file.path()}}.}

\item{strict}{If \code{TRUE}, an error will be issued if the specified file does
not exist}

\item{file}{A single string of file name.}
}
\description{
Get file path from EnergyPlus installation directory
}
\details{
\itemize{
\item \code{path_eplus()} returns the file path specified in EnergyPlus installation
directory.
\item \code{path_eplus_processor()} is the same as \code{path_eplus()} expect it
automatically prepend the executable extension, i.e. \code{.exe} on Windows and
empty on macOS and Linux.
\item \code{path_eplus_example()} returns the file path specified under the \code{ExampleFiles}
folder in EnergyPlus installation directory.
\item \code{path_eplus_weather()} returns the file path specified under the
\code{WeatherData} folder in EnergyPlus installation directory.
\item \code{path_eplus_dataset()} returns the file path specified under the
\code{DataSets} folder in EnergyPlus installation directory.
}
}
\examples{
\dontrun{
path_eplus(8.8, "Energy+.idd")

path_eplus_processor(8.8, "EPMacro", strict = TRUE)
path_eplus_processor(8.8, "PreProcess", "GrndTempCalc", "Slab", strict = TRUE)

path_eplus_example(8.8, "1ZoneUncontrolled.idf")
path_eplus_example(8.8, "BasicFiles/Exercise1A.idf")

path_eplus_weather(8.8, "USA_CA_San.Francisco.Intl.AP.724940_TMY3.ddy")

path_eplus_dataset(8.8, "Boilers.idf")
path_eplus_dataset(8.8, "FMUs/MoistAir.fmu")
}
}
\author{
Hongyuan Jia
}
