% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spCountIndex.R
\name{spCountIndex}
\alias{spCountIndex}
\title{Identify cells that have a certain number of taxa}
\usage{
spCountIndex(x, count)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{count}{number of species to consider (can be a vector of integers)}
}
\value{
numeric vector of grid cell indices.
}
\description{
Given a epmGrid object, return the grid cell indices
	of those cells that have the specified number of taxa.
}
\details{
This function can be useful when further analyzing epmGrid
	objects generated by \code{\link{gridMetrics}}, as it might
	make sense to exclude certain grid cells in further analyses.
}
\examples{
spCountIndex(tamiasEPM, count = 1)
spCountIndex(tamiasEPM, count = 1:3)

}
\author{
Pascal Title
}
