% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d-package.R
\docType{package}
\name{eq5d-package}
\alias{eq5d-package}
\title{eq5d: Methods for Analysing 'EQ-5D' Data and Calculating 'EQ-5D' Index Scores}
\description{
EQ-5D is a popular health related quality of life instrument used in the clinical and economic evaluation of health care. Developed by the EuroQol group \url{https://euroqol.org/}, the instrument consists of two components: health state description and evaluation. For the description component a subject self-rates their health in terms of five dimensions; mobility, self-care, usual activities, pain/discomfort, and anxiety/depression using either a three-level (EQ-5D-3L, \url{https://euroqol.org/information-and-support/euroqol-instruments/eq-5d-3l/}) or a five-level (EQ-5D-5L, \url{https://euroqol.org/information-and-support/euroqol-instruments/eq-5d-5l/}) scale. Frequently the scores on these five dimensions are converted to a single utility index using country specific value sets, which can be used in the clinical and economic evaluation of health care as well as in population health surveys. The eq5d package provides methods to calculate index scores from a subject's dimension scores. 32 TTO and 11 VAS EQ-5D-3L value sets including those for countries in Szende et al (2007) \doi{10.1007/1-4020-5511-0} and Szende et al (2014) \doi{10.1007/978-94-007-7596-1}, 46 EQ-5D-5L EQ-VT value sets, the EQ-5D-5L crosswalk value sets developed by van Hout et al. (2012) \doi{10.1016/j.jval.2012.02.008}, the crosswalk value sets for Bermuda, Jordan and Russia and the reverse crosswalk value sets. 10 EQ-5D-Y value sets are also included as are the NICE 'DSU' age-sex based EQ-5D-3L to EQ-5D-5L and EQ-5D-5L to EQ-5D-3L mappings. Methods are also included for the analysis of EQ-5D profiles, including those from the book "Methods for Analyzing and Reporting EQ-5D data" by Devlin et al. (2020) \doi{10.1007/978-3-030-47622-9}. Additionally a shiny web tool is included to enable the calculation, visualisation and automated statistical analysis of EQ-5D data via a web browser using EQ-5D dimension scores stored in CSV or Excel files.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/fragla/eq5d}
  \item Report bugs at \url{https://github.com/fragla/eq5d/issues}
}

}
\author{
\strong{Maintainer}: Fraser Morton \email{fraser.morton@glasgow.ac.uk}

Authors:
\itemize{
  \item Jagtar Singh Nijjar
}

}
\keyword{internal}
