% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{idegreeL-ergmTerm}
\alias{idegreeL-ergmTerm}
\alias{InitErgmTerm.idegreeL}
\title{In-degree}
\usage{
# binary: idegreeL(d, by=NULL, homophily=FALSE, levels=NULL)
}
\arguments{
\item{d}{a vector of distinct integers.}

\item{by}{an optional character string giving the name of an attribute in the
network's vertex attribute list.}

\item{homophily}{only applied if by is specified. If set (\code{homophile == TRUE}),
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
Otherwise (the default), then separate degree
statistics are calculated for nodes having each separate
value of the attribute.}

\item{levels}{if \code{by} is specified, which levels to consider.}

\item{Ls}{either a Layer Logic specification formula (c.f. Layer Logic section in the \code{\link[=Layer]{Layer()}} documentation) or a list thereof (constructed by \code{\link[=list]{list()}} or \code{\link[=c]{c()}}). If given, degree of a node}
}
\description{
This term adds one network statistic to
the model for each element in \code{d} ; the \eqn{i} th such statistic equals
the number of nodes in the network of in-degree \code{d[i]} , i.e. the number
of nodes with exactly \code{d[i]} in-edges.
This term can only be used with directed networks; for undirected networks
see \code{degree} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "idegreeL", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{frequently-used}
