% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{mutual-ergmTerm}
\alias{mutual-ergmTerm}
\alias{InitErgmTerm.mutual}
\alias{InitWtErgmTerm.mutual}
\title{Mutuality}
\usage{
# binary: mutual(same=NULL, by=NULL, diff=FALSE, keep=NULL, levels=NULL)

# valued: mutual(form="min",threshold=0)
}
\arguments{
\item{same}{if the optional argument is passed
(see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details),
only mutual pairs that match on the attribute are counted;
separate counts for each unique matching value can be obtained by using
\code{diff=TRUE} with \code{same}. Only one of \code{same} or \code{by} may be used. If both parameters are used, \code{by} is
ignored. This paramer is affected by \code{diff}.}

\item{by}{if the optional argument is passed (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details),
then each node is counted separately for each mutual pair in which it
occurs and the counts are tabulated by unique values of the attribute.
This means that the sum of the mutual statistics when \code{by} is used
will equal twice the standard mutual statistic. Only one of \code{same} or \code{by} may be used. If both parameters are used, \code{by} is
ignored. This paramer is not affected by \code{diff}.}

\item{keep}{deprecated}

\item{levels}{which statistics should be kept whenever the \code{mutual} term would ordinarily result in multiple statistics. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{form, threshold}{variant to be used in the valued case.}
}
\description{
In binary ERGMs, equal to the number of
pairs of actors \eqn{i} and \eqn{j} for which \eqn{(i{\rightarrow}j)}{(i,j)}
and \eqn{(j{\rightarrow}i)}{(j,i)} both exist.

For valued ERGMs, equal to \eqn{\sum_{i<j} m(y_{i,j},y_{j,i})} ,
where \eqn{m} is determined by \code{form} argument: \code{"min"}
for \eqn{\min(y_{i,j},y_{j,i})}, \code{"nabsdiff"} for
\eqn{-|y_{i,j},y_{j,i}|}, \code{"product"} for
\eqn{y_{i,j}y_{j,i}}, and \code{"geometric"} for
\eqn{\sqrt{y_{i,j}}\sqrt{y_{j,i}}}. See Krivitsky (2012) for a
discussion of these statistics. \code{form="threshold"} simply
computes the binary \code{mutuality} after
thresholding at \code{threshold}.

This term can only be used with directed networks.
}
\note{
The argument \code{keep} is retained for backwards compatibility and may be
removed in a future version. When both \code{keep} and \code{levels} are passed,
\code{levels} overrides \code{keep}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "mutual", "subsection")}
}
\concept{directed}
\concept{frequently-used}
