% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.network.R
\name{summary_formula}
\alias{summary_formula}
\alias{summary_formula.ergm}
\alias{summary_formula.network.list}
\alias{summary_formula.network}
\alias{summary_formula.ergm_state}
\alias{summary_formula.matrix}
\alias{summary_formula.default}
\title{Dispatching a summary function based on the class of the LHS of a
formula.}
\usage{
summary_formula(object, ..., basis = NULL)

\method{summary_formula}{ergm}(object, ..., basis = NULL)

\method{summary_formula}{network.list}(object, response = NULL, ..., basis = eval_lhs.formula(object))

\method{summary_formula}{network}(object, response = NULL, ..., basis = ergm.getnetwork(object))

\method{summary_formula}{ergm_state}(object, ..., basis = NULL)

\method{summary_formula}{matrix}(object, response = NULL, ..., basis = ergm.getnetwork(object))

\method{summary_formula}{default}(object, response = NULL, ..., basis = ergm.getnetwork(object))
}
\arguments{
\item{object}{A two-sided formula.}

\item{\dots}{further arguments passed to or used by methods.}

\item{basis}{Optional object of the same class as the LHS of the formula, substituted in place of the LHS.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}
}
\value{
A vector of statistics measured on the network.
}
\description{
The generic \code{\link[=summary_formula]{summary_formula()}} (note the underscore) expects a
formula argument and will attempt to identify the class of the LHS
of the formula and dispatch to the appropriate \code{summary_formula}
method.
}
\section{Methods (by class)}{
\itemize{
\item \code{ergm}: an \code{\link{ergm}} fit method, extracting its model from the fit.

\item \code{network.list}: a method for a \code{\link{network.list}} on the LHS of the formula.

\item \code{network}: a method for a \code{\link{network}} on the LHS of the formula.

\item \code{ergm_state}: a method for the semi-internal \code{\link{ergm_state}} on the LHS of the formula.

\item \code{matrix}: a method for a \code{\link{matrix}} on the LHS of the formula.

\item \code{default}: a fallback method.
}}

\examples{

#
# Lets look at the Florentine marriage data
#
data(florentine)
#
# test the summary_formula function
#
summary(flomarriage ~ edges + kstar(2))
m <- as.matrix(flomarriage)
summary(m ~ edges)  # twice as large as it should be
summary(m ~ edges, directed=FALSE) # Now it's correct

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[=network]{network()}}, \code{\link{ergmTerm}}

\code{\link[=summary.ergm_model]{summary.ergm_model()}}
}
\keyword{internal}
\keyword{models}
