% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{smalldiff-ergmTerm}
\alias{smalldiff-ergmTerm}
\alias{InitErgmTerm.smalldiff}
\title{Number of ties between actors with similar attribute values}
\usage{
# binary: smalldiff(attr, cutoff)
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{maximum}{difference in attribute values for ties to be considered}
}
\description{
This term adds one statistic, having as its
value the number of edges in the network for which the incident
actors' attribute values differ less than \code{cutoff} ; that is,
number of edges between \code{i} to \code{j} such that
\code{abs(attr[i]-attr[j])<cutoff} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "smalldiff", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{quantitative nodal attribute}
\concept{undirected}
