% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R
\name{wrap.ergm_model}
\alias{wrap.ergm_model}
\title{Wrap a submodel's curved, empty network statistics, and extended
state (read-only) specification (if present) for output from an
\code{InitErgmTerm} or \code{InitWtErgmTerm}.}
\usage{
wrap.ergm_model(m, nw, namewrap = identity)
}
\arguments{
\item{m}{An \code{ergm_model} object.}

\item{nw}{A \code{network} object.}

\item{namewrap}{An optional function taking a character vector and
returning a character vector of the same length, called on the
model's canonical and curved parameter names to wrap them. Set to
\code{NULL} for auxiliary terms to avoid generating elements not
relevant to auxiliaries.}
}
\value{
a list with elements \code{map}, \code{gradient}, \code{params},
\code{emptynwstats}, \code{dependence}, \code{offsettheta}, and \code{offsetmap},
suitable for concatenating with an \code{InitErgmTerm} or
\code{InitWtErgmTerm} output list (possibly after modification).
}
\description{
Given a \code{ergm} model and (optionally) a function with which to wrap
parameter names, wrap the calls to its \code{ergm.eta()} and
\code{ergm.etagrad()} into \code{map()} and \code{gradient()} functions, similarly
with the \code{params} element; wrap empty network statistics; wrap
indicator of dyadic independence; and wrap offset indicators.
}
\details{
\code{namewrap} also controls how dyadic dependence flag is propagated
for auxiliaries. If \code{NULL}, it is propagated; if not, the
auxiliaries are ignored and only terms's dyadic dependence is
propagated.
}
\keyword{internal}
