% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\name{ergmTerm}
\alias{ergmTerm}
\alias{ergm-terms}
\alias{ergm.terms}
\alias{terms-ergm}
\alias{terms.ergm}
\alias{InitErgmTerm}
\alias{InitErgmWtTerm}
\title{Terms used in Exponential Family Random Graph Models}
\description{
This page explains how to specify the network statistics \eqn{g(y)} to functions in the \code{\link[=ergm-package]{ergm}} package and packages that extend it. It also provides an indexed list of the possible terms (and hence network statistics) visible to the \CRANpkg{ergm} API. Terms can also be searched via \code{\link{search.ergmTerms}}, and help for an individual term can be obtained with \verb{ergmTerm?<term>} or \code{help("<term>-ergmTerm")}.
}
\section{Specifying models}{

\ERGMspec

Network statistics \eqn{g(y)} and mappings \eqn{\eta(\theta)} are specified by a formula object, of the form \verb{y ~ <term 1> + <term 2> ...}, where
\code{y} is a network object or a matrix that can be coerced to a network
object, and \verb{<term 1>}, \verb{<term 2>}, etc, are each terms chosen
from the list given below.  To create a network object in , use the
\code{\link[network:network]{network}} function, then add nodal attributes to it
using the \verb{\%v\%} operator if necessary.
\subsection{Term operators}{

Operator terms like \ergmTerm{ergm}{B}{()} and \ergmTerm{ergm}{F}{()} take
formulas with other \code{\link{ergm}} terms as their arguments and transform them
by modifying their inputs (e.g., the network they evaluate) and/or their
outputs.

By convention, their names are capitalized and CamelCased.
}

\subsection{Interactions}{

For binary ERGMs, interactions between \code{\link{ergm}} terms can be
specified in a manner similar to \code{\link{lm}} and others, as using the
\code{:} and \code{*} operators. However, they must be interpreted
carefully, especially for dyad-dependent terms. (Interactions involving
curved terms are not supported at this time.)

Generally, if term \code{a} has \eqn{p_a}{p[a]} statistics and \code{b} has
\eqn{p_b}{p[b]}, \code{a:b} will add \eqn{p_a \times p_b}{p[a]*p[b]}
statistics to the model, corresponding to each element of
\eqn{g_a(y)}{g[a](y)} interacted with each element of \eqn{g_b(y)}{g[b](y)}.

The interaction is defined as follows. Dyad-independent terms can be
expressed in the general form \eqn{g(y;x)=\sum_{i,j} }{sum[i,j]
x[i,j]*y[i,j]}\eqn{ x_{i,j}y_{i,j}}{sum[i,j] x[i,j]*y[i,j]} for some edge
covariate matrix \eqn{x}, \deqn{g_{a:b}(y)=\sum_{i,j}
x_{a,i,j}x_{b,i,j}y_{i,j}.}{g[a:b](y) = \sum[i,j] x[a,i,j]*x[b,i,j]*y[i,j].}
In other words, rather than being a product of their sufficient statistics
(\eqn{g_{a}(y)g_{b}(y)}{g[a](y)*g[b](y)}), it is a dyadwise product of their
dyad-level effects.

This means that an interaction between two dyad-independent terms can be
interpreted the same way as it would be in the corresponding logistic
regression for each potential edge. However, for undirected networks in
particular, this may lead to somewhat counterintuitive results. For example,
given two nodal covariates \code{"a"} and \code{"b"} (whose values for node
\eqn{i} are denoted \eqn{a_i}{a[i]} and \eqn{b_i}{b[i]}, respectively),
\code{nodecov("a")} adds one statistic of the form \eqn{\sum_{i,j}
(a_{i}+a_{j}) y_{i,j}}{sum[i,j] (a[i]+a[j])*y[i,j]} and analogously for
\code{nodecov("b")}, so \code{nodecov("a"):nodecov("b")} produces
\deqn{\sum_{i,j} (a_{i}+a_{j}) (b_{i}+b_{j}) y_{i,j}.}{sum[i,j]
(a[i]+a[j])*(b[i]+b[j])*y[i,j].}
}

\subsection{Binary and valued ERGM terms}{

\code{\link[=ergm-package]{ergm}} functions such as \code{\link{ergm}} and
\code{\link[=simulate.formula]{simulate}} (for ERGMs) may operate in two
modes: binary and weighted/valued, with the latter activated by passing a
non-NULL value as the \code{response} argument, giving the edge attribute
name to be modeled/simulated.
\subsection{Generalizations of binary terms}{

Binary ERGM statistics cannot be
used directly in valued mode and vice versa. However, a substantial number
of binary ERGM statistics --- particularly the ones with dyadic independence
--- have simple generalizations to valued ERGMs, and have been adapted in
\code{\link[=ergm-package]{ergm}}. They have the same form as their binary
ERGM counterparts, with an additional argument: \code{form}, which, at this
time, has two possible values: \code{"sum"} (the default) and
\code{"nonzero"}. The former creates a statistic of the form \eqn{\sum_{i,j}
x_{i,j} y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is the
value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the term's covariate
associated with it. The latter computes the binary version, with the edge
considered to be present if its value is not 0.  Valued version of some
binary ERGM terms have an argument \code{threshold}, which sets the value
above which a dyad is conidered to have a tie. (Value less than or equal to
\code{threshold} is considered a nontie.)

The \ergmTerm{ergm}{B}{()} operator term documented below can be used to pass other
binary terms to valued models, and is more flexible, at the cost of being
somewhat slower.
}

\subsection{Transformations of dyad values}{

A expression of the form \code{... + (EXPR ~ TERMS) + ...} will evaluate
\code{TERMS} on a network constructed by applying the transformation
specified by \code{EXPR} to edge values. At this time, \code{"sqrt"} is the
only transformation supported (e.g., \code{("sqrt" ~ sum)} is equivalent
to \code{sum(pow = 1/2)}).
}

}

\subsection{Nodal attribute levels and indices}{

Terms taking a categorical nodal covariate also take the \code{levels}
argument.  (There are analogous \code{b1levels} and \code{b2levels}
arguments for some terms that apply to bipartite networks, and the
\code{levels2} argument for mixing terms.)  The \code{levels} argument can
be used to control the set and the ordering of attribute levels.

Terms that allow the selection of nodes do so with the \code{nodes}
argument, which is interpreted in the same way as the \code{levels}
argument, where the categories are the relevant nodal indices themselves.

Both \code{levels} and \code{nodes} use the new level selection UI. (See
\link[=nodal_attributes]{Specifying Vertex attributes and Levels} (\verb{?
nodal_attributes}) for details.)
\subsection{Legacy arguments}{

The legacy \code{base} and \code{keep} arguments are deprecated as of
version 3.10, and replaced by the \code{levels} UI. The \code{levels}
argument provides consistent and flexible mechanisms for specifying which
attribute levels to exclude (previously handled by \code{base}) and include
(previously handled by \code{keep}).  If \code{levels} or \code{nodes}
argument is given, then \code{base} and \code{keep} arguments are ignored.
The legacy arguments will most likely be removed in a future version.

Note that this exact behavior is new in version 3.10, and it differs
slightly from older versions: previously if both \code{levels} and
\code{base}/\code{keep} were given, \code{levels} argument was applied first
and then applied the \code{base}/\code{keep} argument. Since version 3.10,
\code{base}/\code{keep} would be ignored, even if old term behavior is
invoked (as described in the next section).
}

}

\subsection{Term versioning}{

When a term's behavior has changed from prior version, it is often possible
to invoke the old behavior by setting and/or passing a \code{version} term
option, giving the verison (constructed by \code{\link{as.package_version}})
desired.
}

\subsection{Custom \code{ergm} terms}{

Users and other packages may build custom terms, and package
\pkg{ergm.userterms} (\url{https://github.com/statnet/ergm.userterms}) provides
tools for implementing them, and the \href{https://cran.r-project.org/package=ergm/vignettes/Terms-API.html}{Terms-API vignette}.

There is also a number of \emph{auxiliaries} available---terms that do
not have statistics of their own but provide data structures useful
to other terms. For auxiliaries currently visible to
\CRANpkg{ergm}, see \code{\link{ergmAuxiliary}}.

The current recommendation for any package implementing additional terms is
to document the term with Roxygen comments and a name in the form
\code{termName-ergmTerm}. This ensures that \code{help("ergmTerm")} will list ERGM
terms available from all loaded packages.
}
}

\section{Terms included in the \code{\link[=ergm-package]{ergm}} package}{

As noted above, a cross-referenced HTML version of the term documentation is
also available via \code{vignette('ergm-term-crossRef')} and terms
can also be searched via \code{\link{search.ergmTerms}}.

\ergmCSS
\subsection{Term index (plain)}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~!"operator"\%in\%.))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~!"operator"\%in\%.))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~!"operator"\%in\%.))}}
}

\subsection{Term index (operator)}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~"operator"\%in\%.))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~"operator"\%in\%.))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmTerm", keywords = ~"operator"\%in\%.))}}
}

\subsection{Frequently-used terms}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmTerm", keywords=~"frequently-used"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular)$name))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmTerm", keywords=~"frequently-used"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular)$name))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmTerm", keywords=~"frequently-used"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular)$name))}}
}

\subsection{Operator terms}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmTerm", keywords=~"operator"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular & name!="operator")$name))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmTerm", keywords=~"operator"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular & name!="operator")$name))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmTerm", keywords=~"operator"\%in\%., display.keywords = subset(ergm::ergm_keyword(), popular & name!="operator")$name))}}
}

\subsection{All terms}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmTerm"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmTerm"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmTerm"))}}
}

\subsection{Terms by keywords}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocLatex(ergm:::.termToc("ergmTerm"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocText(ergm:::.termToc("ergmTerm"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocHtml(ergm:::.termToc("ergmTerm"))}}
}
}

\examples{
\dontrun{
ergm(flomarriage ~ kstar(1:2) + absdiff("wealth") + triangle)

ergm(molecule ~ edges + kstar(2:3) + triangle
                      + nodematch("atomic type",diff=TRUE)
                      + triangle + absdiff("atomic type"))
}
}
\references{
\itemize{
\item Krivitsky P. N., Hunter D. R., Morris M., Klumb
C. (2021). "ergm 4.0: New features and improvements."
arXiv:2106.04997. \url{https://arxiv.org/abs/2106.04997}
\item Bomiriya, R. P, Bansal, S., and Hunter, D. R. (2014).  Modeling
Homophily in ERGMs for Bipartite Networks.  Submitted.
\item Butts, CT.  (2008).  "A Relational Event Framework for Social
Action." \emph{Sociological Methodology,} 38(1).
\item Davis, J.A. and Leinhardt, S.  (1972).  The Structure of Positive
Interpersonal Relations in Small Groups.  In J. Berger (Ed.),
\emph{Sociological Theories in Progress, Volume 2}, 218--251.  Boston:
Houghton Mifflin.
\item Holland, P. W. and S. Leinhardt (1981). An exponential family of
probability distributions for directed graphs.  \emph{Journal of the
American Statistical Association}, 76: 33--50.
\item Hunter, D. R. and M. S. Handcock (2006). Inference in curved
exponential family models for networks. \emph{Journal of Computational and
Graphical Statistics}, 15: 565--583.
\item Hunter, D. R. (2007). Curved exponential family models for social
networks. \emph{Social Networks}, 29: 216--230.
\item Krackhardt, D. and Handcock, M. S. (2007).  Heider versus Simmel:
Emergent Features in Dynamic Structures. \emph{Lecture Notes in Computer
Science}, 4503, 14--27.
\item Krivitsky P. N. (2012). Exponential-Family Random Graph Models for
Valued Networks. \emph{Electronic Journal of Statistics}, 2012, 6,
1100-1128. \doi{10.1214/12-EJS696}
\item Robins, G; Pattison, P; and Wang, P.  (2009).  "Closure,
Connectivity, and Degree Distributions: Exponential Random Graph (p*) Models
for Directed Social Networks." \emph{Social Networks,} 31:105-117.
\item Snijders T. A. B., G. G. van de Bunt, and C. E. G. Steglich.
Introduction to Stochastic Actor-Based Models for Network Dynamics.
\emph{Social Networks}, 2010, 32(1), 44-60. \doi{10.1016/j.socnet.2009.02.004}
\item Morris M, Handcock MS, and Hunter DR. Specification of
Exponential-Family Random Graph Models: Terms and Computational Aspects.
\emph{Journal of Statistical Software}, 2008, 24(4), 1-24.
\doi{10.18637/jss.v024.i04}
\item Snijders, T. A. B., P. E. Pattison, G. L. Robins, and M. S. Handcock
(2006). New specifications for exponential random graph models,
\emph{Sociological Methodology}, 36(1): 99-153.
}
}
\seealso{
\code{\link[=ergm-package]{ergm}} package, \code{\link{search.ergmTerms}}, \code{\link{ergm}}, \code{\link[network:network]{network}}, \code{\link[network:network.extraction]{\%v\%}}, \code{\link[network:network.extraction]{\%n\%}}
}
\keyword{models}
