% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulae.R
\name{ergmito_formulae}
\alias{ergmito_formulae}
\alias{ergmito_loglik}
\title{Processing formulas in \code{ergmito}}
\usage{
ergmito_formulae(
  model,
  model_update = NULL,
  target_stats = NULL,
  stats_weights = NULL,
  stats_statmat = NULL,
  target_offset = NULL,
  stats_offset = NULL,
  env = parent.frame(),
  ...
)
}
\arguments{
\item{model}{A formula. The left-hand-side can be either a small network, or
a list of networks.}

\item{model_update}{A formula. If specified, the after computing the
sufficient statistics (observed and support), the model is updated using
\code{\link[stats:model.frame]{stats::model.frame()}}. This includes processing offset terms.}

\item{target_stats}{Observed statistics. If multiple networks, then a list, otherwise
a named vector (see \link[ergm:summary_formula]{ergm::summary_formula}).}

\item{stats_weights, stats_statmat}{Lists of sufficient statistics and their
respective weights.}

\item{target_offset, stats_offset}{See \code{\link[=exact_loglik]{exact_loglik()}}.}

\item{env}{Environment in which \code{model} should be evaluated.}

\item{...}{Further arguments passed to \link[ergm:ergm.allstats]{ergm::ergm.allstats}.}
}
\value{
A list of class \code{ergmito_loglik}.
\itemize{
\item \code{loglik} A function. The log-likelihood function.
\item \code{grad} A function. The gradient of the model.
\item \code{stats_weights},\code{stats_statmat} two list of objects as returned by
\link[ergm:ergm.allstats]{ergm::ergm.allstats}.
\item \code{target_offset},\code{stats_offset} A vector of offset terms and a list of
vectors of offset terms, one for the target stats and the other for the
support of the sufficient statistics (defaults to 0).
\item \code{model} A formula. The model passed.
\item \code{npars} Integer. Number of parameters.
\item \code{nnets} Integer. Number of networks in the model.
\item \code{vertex_attr} Character vector. Vertex attributes used in the model.
\item \code{term_names} Names of the terms used in the model.
}
}
\description{
Analyze formula objects returning the matrices of weights and sufficient
statistics to be used in the model together with the log-likelihood and
gradient functions for joint models.
}
\details{
One of the main advantages of been able to compute exact likelihoods is that
we can build arbitrarily complex models in the same way that we would do in
the context of Generalized Linear Models, this is, adding offset terms,
interaction effects, or transformations of statistics without much effort.

In particular, if the user passes a formula via \code{model_update}, the
cannonical additive ERGM can be modified to include other terms, for example,
if we wanted to add an interaction effect of the \code{nodematch("age")} with
network size, we can simply type\preformatted{model_update = ~ . + I(nodematch.age * n)
}

The \code{\link[=I]{I()}} function allows operating over variables in the model, in this case,
we took the \code{nodematch.age} variable (which is the name that \code{\link[ergm:ergm]{ergm::ergm()}}
assigns to it after computing the sufficient statistics) and multiplied it by
\code{n}, which is the network size (this variable is included by default).

By default, the ergm package calculates up to 2^16 unique values for the
vector of sufficient statistics. This results in issues if the user tries to
fit a model with too heterogenous networks or sets of attributes. To deal
with this it suffices with adding the option \code{maxNumChangeStatVectors} in
the ergmito call, e.g.:\preformatted{# Networks of size 5 have up to 2^20 unique sets of sufficient statistics
ergmito(..., maxNumChangeStatVectors = 2^20)
}

See more in ?\link[ergm:ergm.allstats]{ergm::ergm.allstats}.
}
\examples{
data(fivenets)
model0 <- ergmito_formulae(fivenets ~ edges + nodematch("female"))
print(model0)
model0$loglik(c(-2, 2))

# Model with interaction effects and an offset term
model1 <- ergmito_formulae(
  fivenets ~ edges + nodematch("female"),
  model_update = ~ . + offset(edges) + I(edges * nodematch.female)
)
}
