% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statement.R
\name{print_string}
\alias{print_string}
\title{Return or Print String}
\usage{
print_string(string, silent = NULL)
}
\arguments{
\item{string}{A single character.}

\item{silent}{\code{TRUE} or \code{FALSE} which indicates if to return \code{string}
silently or print it. The default value is \code{FALSE}.}
}
\value{
If \code{silent} is \code{TRUE}, \code{string} is returned. And if \code{silent} is
\code{FALSE}, \code{string} is printed, and invisible \code{string} is returned.
}
\description{
Can be used in user-defined \code{print()} methods to
return silently generated strings, or print them.
}
\examples{
s <- "I'm a string."

# print `s`
print_string(s)

# return `s`
print_string(s, TRUE)
}
