% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/throw.R
\name{throw}
\alias{throw}
\title{Generate and Signal Condition}
\usage{
throw(general, specifics = NULL, env = NULL, as = "error", class = NULL, ...)
}
\arguments{
\item{general}{A single character which gives a general statement of
the condition.}

\item{specifics}{Optional. A character vector which gives a list of details
of the condition. If is \code{character(0)}, \code{throw()} will return silently.
If is a named vector, the names are used to create bullets. If the name is
\code{"x"} or \code{"i"}, the bullet will be colored and bold. The default name is
\code{"x"}. You can customize bullets with option \code{erify.bullets}.}

\item{env}{Optional. An environment or named list which is used to evaluate
the R code in the above arguments. See \code{\link[glue:glue]{glue::glue()}}.}

\item{as}{Optional. \code{"error"}, \code{"warning"} or \code{"message"} which indicates
how to signal the condition. The default value is \code{"error"}.}

\item{class}{Optional. A character vector which assigns classes to the
condition.}

\item{...}{Optional. Additional arguments which are stored in the
condition and can be retrieved with \code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
If \code{specifics} is \code{character(0)}, returns an invisible \code{NULL}.
Or signals an error, a warning, or a message.
}
\description{
Generate and signal a condition.
}
\examples{
general <- "You are wrong."

# returns silently
throw(general, character(0))

\dontrun{
throw(general)

specifics <- c("Detail 1.", i = "Detail 2.")
throw(general, specifics)

# embed R code with glue syntax
throw("`x` is {x}.", env = list(x = 1))
}

# add and retrieve additional argument
tryCatch(
  { throw(general, arg = "I'm an additional argument.") },
  error = function(e) e$arg
)
}
