% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{fullErnmLikelihood}
\alias{fullErnmLikelihood}
\title{Likelihood for a fully observed ernm}
\usage{
fullErnmLikelihood(
  theta,
  sample,
  theta0,
  stats,
  minEss = 5,
  damping = 0.05,
  method = c("cumulant", "sample"),
  order = 3
)
}
\arguments{
\item{theta}{parameters}

\item{sample}{mcmc sample}

\item{theta0}{parameter values which generated sample}

\item{stats}{observed statistics}

\item{minEss}{minimum effective sample size}

\item{damping}{a damping parameter}

\item{method}{the method of partition function approximation to use}

\item{order}{the order of the cumulant approximation}
}
\value{
a list with value, gradient, and hessian
}
\description{
This function approximates the likelihood around a sample
generated at parameters theta0. The likelihood is only
"trusted" within a vicinity of theta0. The size of this
vicinity is controlled by requiring a minimum effective
sample size (minESS) at theta + (theta - tehta0) * damping.
}
