% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{measure.default}
\alias{measure.default}
\title{Measure}
\usage{
\method{measure}{default}(s, acc, f = function(x, y) {     abs(x - y) })
}
\arguments{
\item{s}{confidence level, e,g. s=0.05 for the standard 95 percent confidence interval.}

\item{acc}{accuracy achieved by error intervals.}

\item{f}{function used to compute error of intervals. See also 'Details'.}
}
\value{
Returns an object of class \code{c("measure","list")}
with information regarding the error of a set of intervals.
}
\description{
\code{measure} creates an object of class
 \code{c("measure", "list")}.
}
\examples{
measure(0.1,0.7)

measure(0.1,0.7,function(x,y){y-x})
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

