% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED1_SSR.boundary}
\alias{AED1_SSR.boundary}
\title{Calculate the critical value used at the final analysis of the
  Adaptive Enrichment Design (Strategy 1) with Sample Size Re-estimation Procedure}
\usage{
AED1_SSR.boundary(rho, alpha, pstar, Info, epsilon)
}
\arguments{
\item{rho}{The proportion of subgroup 1.}

\item{alpha}{The overall Type I error rate.}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}

\item{Info}{The observation information, which is commonly calculated through
the sample size used at each stage of the trial.}

\item{epsilon}{The threshold of the difference between subgroup-specific test
statistics.}
}
\description{
The \code{AED1_SSR.boundary()} is used to calculate the critical
  value required at the final analysis of the Adaptive Enrichment Design
  (Strategy 1) with sample size
  re-estimation procedure. In the AED1-SSR design, the adaptive enrichment
  strategy is guided by a pre-specified futility stopping boundary and a
  threshold of the difference between the subgroup-specific test statistics.
}
\examples{
AED1_SSR.boundary(rho = 0.5, alpha = 0.05, pstar = 0.2, Info = 0.5, epsilon = 0.5)
}
\references{
\itemize{
  \item Zhao Yang, Ruitao Lin, Guosheng Yin and Ying Yuan. (2018) Sample Size
    Re-estimation in Adaptive Enrichment Trials. (In preparation)
}
}
