% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{SSR.boundary}
\alias{SSR.boundary}
\title{Calculate the futility and efficacy stopping boundaries for Sample Size
  Re-estimation Procedure based on the conditional error function}
\usage{
SSR.boundary(alpha, pstar)
}
\arguments{
\item{alpha}{The overall Type I error rate}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}
}
\value{
A list contain
\itemize{
  \item upper.boundary The efficacy stopping boundary at the interim analysis
  \item lower.boundary The futility stopping boundary at the interim analysis
}
}
\description{
The \code{SSD.boundary()} is used to calculate the futility
   and efficacy stopping boundaries, meanwhile protect the overall Type I
   error rate at the pre-specified level.
}
\examples{
alpha <- 0.05
pstar <- 0.2
res <- SSR.boundary(alpha = alpha, pstar = pstar)

}
\references{
\itemize{
 \item Proschan MA, Hunsberger SA. Designed extension of studies based on
         conditional power. Biometrics 1995:1315-24. <doi:10.2307/2533262>
}
}
