% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_mean_gain.R
\name{esc_mean_gain}
\alias{esc_mean_gain}
\title{Compute effect size from Mean Gain Scores and Standard Deviations}
\usage{
esc_mean_gain(pre1mean, pre1sd, post1mean, post1sd, grp1n, gain1mean,
  gain1sd, grp1r, pre2mean, pre2sd, post2mean, post2sd, grp2n, gain2mean,
  gain2sd, grp2r, r, es.type = c("d", "g", "or", "logit", "r", "f",
  "eta", "cox.or", "cox.log"), study = NULL)
}
\arguments{
\item{pre1mean}{The mean of the first group at pre-test.}

\item{pre1sd}{The standard deviation of the first group at pre-test.}

\item{post1mean}{The mean of the first group at post-test.}

\item{post1sd}{The standard deviation of the first group at post-test.}

\item{grp1n}{The sample size of the first group.}

\item{gain1mean}{The mean gain between pre and post of the first group.}

\item{gain1sd}{The standard deviation gain between pre and post of the first
group.}

\item{grp1r}{The (estimated) correlation of pre-post scores for the first
group.}

\item{pre2mean}{The mean of the second group at pre-test.}

\item{pre2sd}{The standard deviation of the second group at pre-test.}

\item{post2mean}{The mean of the second group at post-test.}

\item{post2sd}{The standard deviation of the second group at post-test.}

\item{grp2n}{The sample size of the second group.}

\item{gain2mean}{The mean gain between pre and post of the second group.}

\item{gain2sd}{The standard deviation gain between pre and post of the second
group.}

\item{grp2r}{The (estimated) correlation of pre-post scores for the second
group.}

\item{r}{Correlation for within-subject designs (paired samples, repeated measures).}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"f"}}{returns effect size Cohen's \code{f}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{convert_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{convert_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
  \item{\code{"eta"}}{returns effect size eta squared}
}}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size from Mean Gain Scores and Standard
  Deviations for pre-post tests.
}
\details{
For this function, either the gain scores of mean and sd
  (\code{gain1mean} and \code{gain1sd} for the first group and
  \code{gain2mean} and \code{gain2sd} for the second group) must be
  specified, or the pre-post values (\code{pre1mean}, \code{post1mean},
  \code{pre1sd} and \code{post1sd} and the counterpart arguments for the
  second group).
  \cr \cr
  If the pre-post standard deviations are available, no correlation value
  \code{grp1r} resp. \code{grp2r} needs to be specified, because these can
  then be computed based on t-value computation. However, if \code{grp1r}
  is specified, this value will be used (and no t-test performed).
}
\note{
If \code{es.type = "r"}, Fisher's transformation for the effect size
  \code{r} and their confidence intervals are also returned.
}
\examples{
# effect size of mean gain scores, with available pre-post values
esc_mean_gain(pre1mean = 13.07, pre1sd = 11.95, post1mean = 6.1,
              post1sd = 8.33, grp1n = 78, pre2mean = 10.77, pre2sd = 10.73,
              post2mean = 8.83, post2sd = 9.67, grp2n = 83)

# same as above, but with assumed correlation of .5
# Note that effect size is the same, but variance differs
esc_mean_gain(pre1mean = 13.07, pre1sd = 11.95, post1mean = 6.1, grp1r = .5,
              post1sd = 8.33, grp1n = 78, pre2mean = 10.77, pre2sd = 10.73,
              post2mean = 8.83, post2sd = 9.67, grp2n = 83, grp2r = .5)

# effect size based on gain scores for mean and sd. note that the
# pre-post correlations must be given
esc_mean_gain(gain1mean = 1.5, gain1sd = 1, grp1n = 40, grp1r = .5,
              gain2mean = .7, gain2sd = .8, grp2n = 50, grp2r = .5)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}
