## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(escalation)

## -----------------------------------------------------------------------------
model <- get_boin(num_doses = 5, target = 0.3)
fit <- model %>% fit('1NN 2NN 3NT 2NT')

## -----------------------------------------------------------------------------
tox_target(fit)

## -----------------------------------------------------------------------------
num_patients(fit)

## -----------------------------------------------------------------------------
cohort(fit)

## -----------------------------------------------------------------------------
doses_given(fit)

## -----------------------------------------------------------------------------
tox(fit)

## -----------------------------------------------------------------------------
num_tox(fit)

## -----------------------------------------------------------------------------
model_frame(fit)

## -----------------------------------------------------------------------------
num_doses(fit)

## -----------------------------------------------------------------------------
dose_indices(fit)

## -----------------------------------------------------------------------------
recommended_dose(fit)

## -----------------------------------------------------------------------------
continue(fit)

## -----------------------------------------------------------------------------
n_at_dose(fit)

## -----------------------------------------------------------------------------
prob_administer(fit)

## -----------------------------------------------------------------------------
tox_at_dose(fit)

## -----------------------------------------------------------------------------
empiric_tox_rate(fit)

## -----------------------------------------------------------------------------
mean_prob_tox(fit)

## -----------------------------------------------------------------------------
median_prob_tox(fit)

## -----------------------------------------------------------------------------
prob_tox_quantile(fit, 0.9)

## -----------------------------------------------------------------------------
prob_tox_exceeds(fit, 0.5)

## -----------------------------------------------------------------------------
supports_sampling(fit)

