% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatter.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Generates a scatter plot of data for two continuous variables}
\usage{
plot_scatter(
  estimate,
  show_line = FALSE,
  show_line_CI = FALSE,
  show_PI = FALSE,
  show_residuals = FALSE,
  show_mean_lines = FALSE,
  show_r = FALSE,
  predict_from_x = NULL,
  plot_as_z = FALSE,
  ggtheme = ggplot2::theme_classic()
)
}
\arguments{
\item{estimate}{\itemize{
\item an esci_estimate object generated by \code{\link[=estimate_r]{estimate_r()}}
}}

\item{show_line}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to show the
regression line
}}

\item{show_line_CI}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to show the
confidence interval on the regression line
}}

\item{show_PI}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to show prediction
intervals
}}

\item{show_residuals}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to show
residuals of prediction
}}

\item{show_mean_lines}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to plot
lines showing the mean of each variable
}}

\item{show_r}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to print the \emph{r}
value and its CI on the plot
}}

\item{predict_from_x}{\itemize{
\item Optional real number in the range of the x variable
for the plot; Defaults to NULL; if passed, the graph shows the predicted Y'
for this x value
}}

\item{plot_as_z}{\itemize{
\item Boolean; defaults to FALSE; set to TRUE to convert x and y
scores to z scores prior to plotting
}}

\item{ggtheme}{\itemize{
\item Optional ggplot2 theme object to control overall styling;
defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}
}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_scatter} returns a ggplot2 object of data from two continuous
variables.  Can indicate regression line and its confidence
interval,prediction intervals regression residuals and more. This function
requires as input an esci_estimate object generated by \code{\link[=estimate_r]{estimate_r()}}
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# From raw data
data("data_thomason_1")

estimate_from_raw <- esci::estimate_r(
  esci::data_thomason_1,
  Pretest,
  Posttest
)

# To visualize the value of r
myplot_correlation <- esci::plot_correlation(estimate_from_raw)

# To visualize the data (scatterplot) and use regression to obtain Y' from X
myplot_scatter_from_raw <- esci::plot_scatter(estimate_from_raw, predict_from_x = 10)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_raw <- esci::test_correlation(
  estimate_from_raw,
  rope = c(-0.1, 0.1)
)


# From summary data
estimate_from_summary <- esci::estimate_r(r = 0.536, n = 50)

# To visualize the value of r
myplot_correlation_from_summary <- esci::plot_correlation(estimate_from_summary)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_summary <- esci::test_correlation(
  estimate_from_summary,
  rope = c(-0.1, 0.1)
)


}
