% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folrows.R
\name{folrows}
\alias{folrows}
\title{Extract Following Rows from a Dataframe}
\usage{
folrows(.data, n = 5, nb_sample = 1)
}
\arguments{
\item{.data}{The dataframe from which rows are to be extracted.}

\item{n}{The number of consecutive rows to be extracted, including the starting row.
Default is 5.}

\item{nb_sample}{The number of random starting positions to be sampled.
Default is 1.}
}
\value{
A dataframe containing the consecutive rows extracted from the randomly chosen starting positions.
}
\description{
The \code{folrows()} function extracts a specified number of consecutive rows,
including the starting row, from a dataframe.
Rows are selected consecutively from randomly chosen starting positions.
The function ensures that the selected rows fall within the valid row range of the dataframe.
}
\examples{
# Extract 3 consecutive rows starting from a random position in the dataset
folrows(esmdata_sim, n = 3)

# Extract 4 consecutive rows starting from 2 random positions in a custom dataframe
folrows(esmdata_sim, n = 4, nb_sample = 2)

}
