% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controws.R
\name{controws}
\alias{controws}
\title{Get Context of Rows}
\usage{
controws(data, input, context = 1, direction = "both")
}
\arguments{
\item{data}{A data frame from which rows and their context will be extracted.}

\item{input}{A numeric vector of row numbers or a logical vector. If a logical vector is given, the function
will extract rows where the vector is TRUE.}

\item{context}{An integer specifying the number of rows above and/or below the target row to include as context.
Default is 1.}

\item{direction}{A character string specifying the direction of context to include. Valid options are "up" for
rows above, "down" for rows below, and "both" for both directions. Default is "both".}
}
\value{
A dataframe containing the targeted rows and their contextual rows. An additional column
'.RowType' indicates whether it is a row given as input ("->") or part of the context ("").
}
\description{
This function extracts specific rows from a data frame along with their context, based on a given range.
It can take either a vector of row numbers or a boolean vector as input. Additionally, the function allows
specifying the direction of the context (above, below, or both) and marks each row as either targeted or context.
}
\examples{
# Example dataframe
data <- data.frame(matrix(rnorm(100), ncol = 5))

# Get context for rows 8 and 15 (using row numbers)
result <- controws(data, c(8, 15), 1, "both")
result

}
