% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_set_tag_value.R
\name{dicom.set.tag.value}
\alias{dicom.set.tag.value}
\title{Change TAG value in DICOM raw data}
\usage{
dicom.set.tag.value(
  dicom.raw.data,
  tag,
  tag.value,
  tag.dictionary = dicom.tag.dictionary()
)
}
\arguments{
\item{dicom.raw.data}{Raw vector, representing the binary extraction of the DICOM file.}

\item{tag}{String vector, representing the list of tags whose value is to be
changed. See note 1.}

\item{tag.value}{String vector,representing the list of new tag values.}

\item{tag.dictionary}{Dataframe, by default equal to \link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}
}
\value{
Returns a raw vector, with new tag values.
}
\description{
The \code{dicom.set.tag.value} function changes, in the DICOM
raw data, the values of the TAG whose VR is a string of characters.
}
\note{
1- The list of tags included in the DICOM file are given by the first columns
of the dataframe provided by the functions \link[espadon]{dicom.browser} and
\link[espadon]{dicom.parser}.

2-  The \code{dicom.set.tag.value} function may take some processing time.
To minimize this time, it is recommended to prepare in advance all the tags to
be modified, and use the \code{dicom.set.tag.value} function only once, as shown in
the example.
}
\examples{
# change the value of tags "(0010,0010)" and "(0010,0020)" in the
# dummy raw data toy.dicom.raw ()
new.raw.data <- dicom.set.tag.value (toy.dicom.raw (), 
                                     tag =  c ("(0010,0010)", "(0010,0020)"),
                                     tag.value = c ("unknown", "000001"))
# change control 
data <- dicom.parser (new.raw.data) 
data[data$TAG \%in\% c ("(0010,0010)", "(0010,0020)"), ]
}
