% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fan_sphere.R
\name{fan.sphere}
\alias{fan.sphere}
\title{Creation of spherical fan object.}
\usage{
fan.sphere(
  angle = 1,
  method = c("regular", "random"),
  origin = c(0, 0, 0),
  ref.pseudo = "",
  frame.of.reference = "",
  alias = "",
  description = "spherical fan"
)
}
\arguments{
\item{angle}{Positive number specifying the angle (or mean angle in case of
\code{method = "random"}) between two nearest vectors.}

\item{method}{Requested method of fan calculation from among 'regular' and
'random'. By default, \code{method = regular}. See details.}

\item{origin}{Numeric vector, giving the xyz coordinates of the fan origin.
By default \code{c (0, 0, 0)}.}

\item{ref.pseudo}{Character string, frame of reference pseudonym of the
created object.}

\item{frame.of.reference}{Character string, frame of reference of the
created object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object.}
}
\value{
Returns a "fan" class object (see \link[espadon]{espadon.class}
for class definitions) containing, among others,
\itemize{
\item \code{$xyz} : a matrix of 3 columns giving the xyz coordinates of the fan rays.
\item \code{$local} : a matrix of 2 columns indicating the polar angle
\code{theta} (rad) and the azimuthal angle \code{phi} (rad) of each ray are added.
}
}
\description{
The \code{fan.sphere} function  creates a "fan" class object
containing, among others, the coordinates of the unit director vectors of
the rays of a spherical fan.
}
\details{
The "regular" and "random" method are explained by \emph{Deserno} \strong{[1]}.
\itemize{
\item If \code{method = "regular"}, the returned vectors composing \code{$xyz} matrix
are regularly equidistributed  at the specified angle.
\item If \code{method = "random"}, the returned vectors composing \code{$xyz} matrix
are randomly equidistributed at the specified angle.
}
}
\examples{
regular.fan <- fan.sphere (angle = 10)
head (regular.fan$xyz)
random.fan <- fan.sphere (angle = 10, method = "random")
head (random.fan$xyz)
library (rgl)
open3d ()
points3d (regular.fan$xyz)
open3d ()
points3d (random.fan$xyz)
}
\references{
\strong{[1]} \insertRef{Deserno}{espadon}
}
\seealso{
\link[espadon]{fan.beam}, \link[espadon]{fan.planar}, \link[espadon]{fan.to.voxel}
}
