% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fan_to_voxel.R
\name{fan.to.voxel}
\alias{fan.to.voxel}
\title{Indices of voxels crossed by a fan}
\usage{
fan.to.voxel(vol, fan, restrict = FALSE, vol.value = 1)
}
\arguments{
\item{vol}{"volume" class object.}

\item{fan}{"fan" class object created by \link[espadon]{fan.sphere} for example.}

\item{restrict}{Boolean. If \code{TRUE}, only the voxels with a value equal
to \code{vol.value} are taken into account.}

\item{vol.value}{Value of the voxels taken into account, in case of \code{restrict = TRUE}}
}
\value{
Returns a dataframe of 4 columns. Each line gives:
\itemize{
\item column "ray.index": the index (i.e. the row number) of the ray
concerned in \code{fan$dxyz},
\item column "vol.index": the index of the voxel crossed in \code{vol$vol.3Ddata},
\item column "l.in": the distance between fan source (i.e. \code{fan$origin})
and the first face of the voxel crossed by the ray,
\item column "dl": the distance crossed by the ray in the voxel.
}
If the rays do not cross any voxel, the dataframe has no row.
}
\description{
The \code{fan.to.voxel} function computes the indices of voxels
crossed by a fan. It is useful for retrieving voxel values and voxel indices
of a volume (dose or ct) along the fan rays.
}
\examples{
vol <- vol.create (pt000 = c(1,10,10), dxyz = c (1 , 1, 1),
                   n.ijk = c(100, 100, 100)) 
fan.origin <- c (50,50,50)                         
fan <- fan.sphere (angle = 10, origin = fan.origin)
fan.voxel <- fan.to.voxel (vol = vol, fan = fan)
head (fan.voxel)

# Use of the 2nd column of fan.voxel to select voxels 
bin <- vol.copy (vol, modality = "binary")
bin$vol3D.data[] <- FALSE
bin$vol3D.data[fan.voxel[,2]] <- TRUE
bin$max.pixel <- TRUE
bin$min.pixel <- FALSE
display.kplane(bin, k=10)
}
\seealso{
\link[espadon]{fan.beam}, \link[espadon]{fan.planar}, \link[espadon]{fan.sphere}.
}
