% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_ref_obj.R
\name{set.reference.obj}
\alias{set.reference.obj}
\title{Set the reference objects of a espadon object}
\usage{
set.reference.obj(obj, ref.obj, add = TRUE)
}
\arguments{
\item{obj}{espadon object of class "dvh", "fan", "histo", "histo2D", "mesh",
"rtplan", "struct", "undef" or "volume".}

\item{ref.obj}{espadon object of class "dvh", "fan", "histo", "histo2D", "mesh",
"rtplan", "struct", "undef" or "volume". List of espadon objects.}

\item{add}{Boolean. If TRUE, the reference objects are added to those already
contained by \code{obj}.}
}
\value{
Returns the espadon object \code{obj}, containing the ref.object.alias
and ref.object.info fields identifying its reference objects
}
\description{
The function \code{set.reference.obj} adds to an espadon object
the information identifying the espadon objects from which it derives.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 6
pat <- toy.load.patient (modality = c("ct", "rtdose", "rtstruct"),
                         roi.name = c("eye"), dxyz = rep (step, 3),
                         beam.nb = 3)
display.obj.links(pat)                          
pat$rtstruct[[1]] <- set.reference.obj(pat$rtstruct[[1]],pat$ct[[1]])  
display.obj.links(pat)                          
}
