% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_from_roi.R
\name{bin.from.roi}
\alias{bin.from.roi}
\title{Creation of a binary volume according to RoI}
\usage{
bin.from.roi(
  vol,
  struct,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  T.MAT = NULL,
  within = TRUE,
  alias = "",
  description = NULL,
  modality = c("binary", "weight"),
  ...
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{struct}{"struct" class object.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the \code{struct} object.
By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct}
object.
By default \code{roi.idx = NULL}. See Details.}

\item{T.MAT}{"t.mat" class object, created by
\link[espadon]{load.patient.from.Rdcm} or \link[espadon]{load.T.MAT}. If
\code{T.MAT = NULL}, \code{struct$ref.pseudo} must be equal to
\code{vol$ref.pseudo} or set to \code{NULL}.}

\item{within}{Boolean, defaults to \code{TRUE}. If \code{within = TRUE}, the
contours included in a RoI are managed,
depending on their \code{$level} field. If \code{within = FALSE}, only the
\code{$level = 0} fields of the RoI are used (i.e. only the external outlines).}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL}
(default value), it will be set to \code{struct$roi.info$roi.pseudo[roi.idx]}.}

\item{modality}{modality ("binary" or "weight") of the generated object.}

\item{...}{additional argument.}
}
\value{
Returns a "volume" class object of "binary" or "weight" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol}.
\itemize{
\item In the “binary” modality, voxels with 50 percent of their volume within
the ROI are set to \code{TRUE}.
\item In the “weight” modality, the value of each voxel is its volume fraction
included in the ROI.
}
}
\description{
The \code{bin.from.roi} function creates a "volume" class object,
of modality "binary" or "weight", by selecting the voxels defined by the RoI.
}
\details{
\code{roi.name}, \code{roi.sname}, and \code{roi.idx} must select
only one RoI.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 3
patient <- toy.load.patient (modality = c("ct", "rtstruct"), 
                             roi.name =  c("eye", "optical nerve", "brain"), 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# "optical nerve" binary, with  modality "binary" and "weight"
binl <- bin.from.roi (CT, struct = S, roi.sname = "left optical",
                      alias = "left_optical_nerve", verbose = FALSE,
                      modality = "binary")
binr <- bin.from.roi (CT, struct = S, roi.sname = "right optical",
                      alias = "right_optical_nerve", verbose = FALSE,
                      modality = "weight")

view.coord <- S$roi.info[S$roi.info$roi.pseudo == "leftopticalnerve",]$Gz
palette <- grey.colors(100, start = 0, end = 1, 
                       alpha = c(0, rep(1,99)))
plot(S, view.coord = view.coord, main ="optical nerves")
plot(binl, view.coord = view.coord, col = palette, 
    cut.interpolate = FALSE, add = TRUE)
plot(binr, view.coord = view.coord, col =palette, 
     cut.interpolate = FALSE, add = TRUE)
plot(S, view.coord = view.coord, lwd = 2, add= TRUE)

\dontrun{
# with a smaller step
step <- 1
patient <- toy.load.patient (modality = c("ct", "rtstruct"), 
                             roi.name =  c("eye", "optical nerve", "brain"), 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]
#' view.coord <- S$roi.info[S$roi.info$roi.pseudo == "leftopticalnerve",]$Gz

# "optical nerve" binary without inclusions management
bin <- bin.from.roi (CT, struct = S, roi.sname = "left optical", 
                     alias = "left_optical_nerve", within = FALSE,
                     verbose = FALSE)
display.plane (CT, top = bin, struct = S, view.coord = view.coord, 
               legend.shift = -80, interpolate = FALSE, main = "Left nerve")

# "optical nerve" binary with inclusions management
bin <- bin.from.roi (CT, struct = S, roi.sname = "left optical", 
                     alias = "left_optical_nerve", within = TRUE,
                     verbose = FALSE)
display.plane (CT, top = bin, struct = S, view.coord = view.coord, 
               legend.shift = -80, interpolate = FALSE, main = "Left nerve") 
}
}
\seealso{
\link[espadon]{bin.from.vol}.
}
