% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{build_aes}
\alias{build_aes}
\title{Build aesthetics to use in a plot}
\usage{
build_aes(data, ..., .list = NULL, geom = NULL)
}
\arguments{
\item{data}{Data to use in the plot.}

\item{...}{Named list of aesthetics.}

\item{.list}{Alternative to \code{...} to use a preexisting named list.}

\item{geom}{Geom to use, according to the geom aesthetics may vary.}
}
\value{
An expression
}
\description{
Build aesthetics to use in a plot
}
\examples{
# Classic
build_aes(iris, x = "Sepal.Width")
build_aes(iris, x = "Sepal.Width", y = "Sepal.Width")

# Explicit geom : no change
build_aes(iris, x = "Species", geom = "bar")

# Little trick if data is count data
df <- data.frame(
  LET = c("A", "B"),
  VAL = c(4, 7)
)
build_aes(df, x = "LET", y = "VAL", geom = "bar")

# e.g. :
library(ggplot2)
ggplot(df) +
  build_aes(df, x = "LET", y = "VAL", geom = "bar") +
  geom_bar(stat = "summary", fun = "mean")
}
