% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.diferencia.proporciones.R
\name{ic.diferencia.proporciones}
\alias{ic.diferencia.proporciones}
\title{Intervalo confianza para la diferencia de dos proporciones.}
\usage{
ic.diferencia.proporciones(x,
                     variable = NULL,
                     introducir = FALSE,
                     confianza = 0.95,
                     grafico = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de x. Si x se refiere una sola variable, el argumento variable es NULL. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{introducir}{Valor lógico. Si introducir = FALSE (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos x y/o variable. Si introducir = TRUE, se le solicitará al ususario que introduzca la información relevante sobre tamaño muestral, valor de la media muestral, etc.}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, confianza = 0.95 (95 por ciento)}

\item{grafico}{Es un valor lógico. Por defecto grafico = FALSE. Si se quiere obtener una representación gráfica del intervalo de confianza obtenido, cambiar el argumento a grafico = TRUE. Nota: Esta opción no está implementada para todos los casos.#'}
}
\description{
Calcula el intervalo de confianza de la diferencia de dos proporciones.

\if{html}{\figure{qricdiferenciaproporciones.png}{options: width="25\%" alt="qricdiferenciaproporciones.png"}}
\if{latex}{\figure{qricdiferenciaproporciones.png}{options: width=3cm}}
}
\details{
Se obtiene el intervalo:

\if{html}{\figure{icdifproporciones.png}{options: width="65\%" alt="icdifproporciones.png"}}
\if{latex}{\figure{icdifproporciones.png}{options: width=12cm}}

Nota: Las proporciones muestrales del error típico son sustituidas por sus estimaciones máximo-verosímiles (proporciones muestrales).
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo-García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
