% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{rank_test}
\alias{rank_test}
\title{An event study rank test.}
\usage{
rank_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of test's statistics and significances.
}
\description{
An original rank test applied to an event study, which is based on
Wilcoxon (1945) rank test.
}
\details{
This procedure uses ranks of abnormal returns to examine significance of each
day in the event window. In order to get ranks of corresponding abnormal
returns, the procedure uses regular R function \code{\link{rank}} with
parameter \code{ties.method = "average"} and \code{na.last = "keep"}. For
this test the estimation period and the event period must not overlap,
otherwise an error will be thrown. The test statistic is assumed to have a
normal distribution (as an approximation). The test is well-specified for the
case, when cross-sectional abnormal returns are not symmetric. The test is
stable to variance increase during event window. This test is more sensitive
to extreme values than sign test. For data with missing data see the
\code{\link{modified_rank_test}}. The significance levels of \eqn{\alpha} are
0.1, 0.05, and 0.01 (marked respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "ELE.PA", "G.MI", "HNR1.HA", "HSX.L",
             "MUV2.DE", "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    rank_test(event_start = as.Date("2001-09-11"),
              event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
rank_test(list_of_returns = securities_returns,
          event_start =  as.Date("2001-09-11"),
          event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item Corrado C.J. \emph{A Nonparametric Test for Abnormal Security-Price
Performance in Event Studies}. Journal of Financial Economics 23:385-395,
1989.
\item Cowan A.R. \emph{Nonparametric Event Study Tests}. Review of
Quantitative Finance and Accounting, 2:343-358, 1992.
\item Campbell C.J., Wasley C.E. \emph{Measuring Security Price Performance
Using Daily NASDAQ Returns}. Journal of Financial Economics 33:73-92, 1993.
\item Savickas R. \emph{Event-Induced Volatility and Tests for Abnormal
Performance}. The Journal of Financial Research, 26(2):156-178, 2003.
}
}
\seealso{
\code{\link{nonparametric_tests}},\code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{corrado_sign_test}},
\code{\link{modified_rank_test}}, and \code{\link{wilcoxon_test}}.
}
