% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{empty_plot}
\alias{empty_plot}
\title{Create an empty plot}
\usage{
empty_plot(x, y, default_xlab = NULL, default_ylab = NULL,
  default_main = NULL, default_xlim = NULL, default_ylim = NULL,
  default_xaxt = NULL, default_yaxt = NULL, default_bty = "n", ...)
}
\arguments{
\item{x}{The x variable to be plotted.}

\item{y}{The y variable to be plotted.}

\item{default_xlab}{The default x-label, which can be overridden by the 
user. Defaults to \code{NULL}, in which case the label is defined by
the default \link[graphics]{plot} function.}

\item{default_ylab}{The default y-label, which can be overridden by the 
user. Defaults to \code{NULL}, in which case the label is defined by
the default \link[graphics]{plot} function.}

\item{default_main}{The default main title, which can be overridden by the 
user. Defaults to \code{NULL}, in which case the title is defined by
the default \link[graphics]{plot} function.}

\item{default_xlim}{The default x-axis limits, which can be overridden by 
the user. Defaults to \code{NULL}, in which case the limits are defined by
the default \link[graphics]{plot} function.}

\item{default_ylim}{The default y-axis limits, which can be overridden by 
the user. Defaults to \code{NULL}, in which case the limits are defined by
the default \link[graphics]{plot} function.}

\item{default_xaxt}{The default x-axis type, which can be overridden by the 
user. Defaults to \code{NULL}, in which case the type is defined by
the default \link[graphics]{plot} function.}

\item{default_yaxt}{The default y-axis type, which can be overridden by the 
user. Defaults to \code{NULL}, in which case the type is defined by
the default \link[graphics]{plot} function.}

\item{default_bty}{The default background type, which can be overridden by 
the user. Defaults to \code{"n"}.}

\item{...}{Additional arguments supplied to \link[graphics]{plot} (e.g., 
\code{xlim}, \code{ylim}, \code{cex}, etc.)}
}
\description{
This function creates an empty plot for further plotting (e.g., via 
\link[graphics]{lines}). What makes the function unique is that it allows
for specification of default \code{xlab}, \code{ylab}, and \code{main}
arguments, while allowing the user to override those arguments. Only really
useful when used within other functions (e.g., \link{pp_plot}).
}
