% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{etrd_account_portfolio}
\alias{etrd_account_portfolio}
\title{ETrade Account Portfolios}
\usage{
etrd_account_portfolio(
  account,
  count = 50,
  marketSession = "REGULAR",
  totalsRequired = "false",
  lotsRequired = "false",
  view = "QUICK",
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{count}{The number of positions to return in the response. If not
specified, defaults to 50. 50 is also the maximum.}

\item{marketSession}{The market session. Default: REGULAR. Options: REGULAR,
EXTENDED}

\item{totalsRequired}{It gives the total values of the portfolio. Default:
false.}

\item{lotsRequired}{It gives position lots for positions. Default: false.}

\item{view}{The view query. Default: Quick. Options: PERFORMANCE,
FUNDAMENTAL, OPTIONSWATCH, QUICK, COMPLETE}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a list of portfolio objects based on request
}
\description{
Provides detailed portfolio information for a selected brokerage account
}
\examples{
\dontrun{

account_id = etrd_account_list()$accountIdKey[1]
et_act_details = etrd_account_portfolio(account_id)
# Convert list to a data frame
positions = dplyr::bind_rows(lapply(et_act_details$AccountPortfolio[[1]]$Position,
                                   function(x) {data.frame(x)}))

}
}
