% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_latent_trawl.R
\name{rlexceed}
\alias{rlexceed}
\title{Simulation of extreme value path using latent trawl process. Transformed
marginals have scale parameter \code{1+kappa}.}
\usage{
rlexceed(alpha, beta, kappa, rho = NA, times, marg.dist, n,
  transformation, trawl.function = NA, trawl.fs = NA,
  trawl.fs.prim = NA, n_moments = 4, deep_cols = 30)
}
\arguments{
\item{alpha}{Shape parameter.}

\item{beta}{Scale parameter.}

\item{kappa}{Additive constant to scale parameter \code{beta}.}

\item{rho}{Trawl parameters. Must be positive if Exponential trawls are used.}

\item{times}{Vectors of discret times.}

\item{marg.dist}{Name of infinitely divisible distribution for latent trawls.
Currenlty implemented: gamma, gaussian, generalised hyperbolic, generalised
inverse gaussian.}

\item{n}{Number of simulations (so far, only \code{n=1} is implemented).}

\item{transformation}{Boolean to apply marginal transform method. Default is
False (F).}

\item{trawl.function}{Type of trawl function that should be used. Default NA.}

\item{trawl.fs}{collection of trawl functions indexed on \code{times}.}

\item{trawl.fs.prim}{collection of trawl functions primitives indexed on
\code{times}.}

\item{n_moments}{Number of finite moments for transformed marginals.}

\item{deep_cols}{Depth of reconstruction (columns). Default is 30.}
}
\value{
Simulated path (size the same as times) of latent-trawl extreme
  value process.
}
\description{
Simulation of extreme value path using latent trawl process. Transformed
marginals have scale parameter \code{1+kappa}.
}
\examples{
alpha <- 3
beta <- 2
kappa <- 0.95
rho <- 0.2
n.timestamps <- 200
times <- 1:n.timestamps

marg.dist <- "gamma"
n <- 1
transformation <- FALSE
trawl.function <- "exp"

rlexceed(alpha = alpha, beta = beta, kappa = kappa, rho = rho, times = times,
         marg.dist = marg.dist, n = n, transformation = transformation,
         trawl.function= trawl.function)

}
