% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma8h.R
\name{ma8h}
\alias{ma8h}
\title{Calculate 8-hour moving average}
\usage{
ma8h(data, time = "date", var, verbose = TRUE, ...)
}
\arguments{
\item{data}{data.frame with time column and variable columns to be processed}

\item{time}{name of the time column (default is date) in POSIXct}

\item{var}{name of the columns to be calculated}

\item{verbose}{display additional information}

\item{...}{parameters passed to hourly}
}
\value{
data.frame with time and the 8-hour moving average
}
\description{
function to calculate Ozone 8-hour moving average for a data.frame
}
\examples{
model_file <- paste(system.file("extdata", package = "eva3dm"),
                                "/model_o3_ugm3_36km.Rds", sep="")
model      <- readRDS(model_file)
model_8h   <- ma8h(model)
plot(model$date,model$Campinas, pch = 19,
     main = expression(O[3]~~'['*mu*g*m^-3*']'))
points(model_8h$date,model_8h$Campinas, col = 'blue', pch = 19)
legend('topleft',bty = 'n',
       pch = 19,
       legend = c('hourly','8h-mov average'),
       col = c('black','blue'))
}
